"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AugmentMessageCodeBlockButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../detection_engine/rule_creation_ui/components/ai_assistant/translations");
var _helpers = require("../helpers");
var _send_to_timeline = require("../send_to_timeline");
var _update_query_in_form = require("../update_query_in_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/assistant/use_augment_message_code_blocks/augment_message_code_block_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AugmentMessageCodeBlockButton = ({
  currentConversation,
  codeBlockDetails
}) => {
  var _codeBlockDetails$con, _codeBlockDetails$con2;
  const sendToTimeline = _helpers.sendToTimelineEligibleQueryTypes.includes(codeBlockDetails.type) && /*#__PURE__*/_react.default.createElement(_send_to_timeline.SendToTimelineButton, {
    asEmptyButton: true,
    dataProviders: [{
      id: 'assistant-data-provider',
      name: `Assistant Query from conversation ${currentConversation.id}`,
      enabled: true,
      excluded: false,
      queryType: codeBlockDetails.type,
      kqlQuery: (_codeBlockDetails$con = codeBlockDetails.content) !== null && _codeBlockDetails$con !== void 0 ? _codeBlockDetails$con : '',
      queryMatch: {
        field: 'host.name',
        operator: ':',
        value: 'test'
      },
      and: []
    }],
    keepDataView: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "timeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
  const updateQueryInForm = _translations.DETECTION_RULES_CREATE_FORM_CONVERSATION_ID === currentConversation.title && /*#__PURE__*/_react.default.createElement(_update_query_in_form.UpdateQueryInFormButton, {
    query: (_codeBlockDetails$con2 = codeBlockDetails.content) !== null && _codeBlockDetails$con2 !== void 0 ? _codeBlockDetails$con2 : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 34
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, sendToTimeline, updateQueryInForm);
};
exports.AugmentMessageCodeBlockButton = AugmentMessageCodeBlockButton;