"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetDiscoveryIntegration = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the path for the Asset Discovery integration.
 * It fetches the integration info and constructs the path pointing to the last version of the integration.
 */
const useAssetDiscoveryIntegration = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const query = (0, _reactQuery.useQuery)(['integrations', _constants.CLOUD_ASSET_DISCOVERY_INTEGRATION_PACKAGE_NAME], () => http.get(_common.epmRouteService.getInfoPath(_constants.CLOUD_ASSET_DISCOVERY_INTEGRATION_PACKAGE_NAME), {
    version: _common.API_VERSIONS.public.v1
  }), {
    retry: false,
    refetchOnWindowFocus: false
  });
  const path = query.isSuccess && http.basePath.prepend(_public.pagePathGetters.add_integration_to_policy({
    pkgkey: (0, _public.pkgKeyFromPackageInfo)({
      name: query.data.item.name,
      version: query.data.item.version
    })
  }).join(''));
  return {
    path,
    isLoading: query.isLoading,
    isError: query.isError,
    error: query.error
  };
};
exports.useAssetDiscoveryIntegration = useAssetDiscoveryIntegration;