"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskSeverity = exports.RiskScoreFields = exports.EntityTypeToScoreField = exports.EntityTypeToLevelField = exports.EMPTY_SEVERITY_COUNT = void 0;
var _types = require("../../../../entity_analytics/types");
var _common = require("../../../../api/entity_analytics/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskSeverity = exports.RiskSeverity = _common.EntityRiskLevelsEnum;
let RiskScoreFields = exports.RiskScoreFields = function (RiskScoreFields) {
  RiskScoreFields["timestamp"] = "@timestamp";
  RiskScoreFields[RiskScoreFields["hostName"] = _types.EntityIdentifierFields.hostName] = "hostName";
  RiskScoreFields["hostRiskScore"] = "host.risk.calculated_score_norm";
  RiskScoreFields["hostRisk"] = "host.risk.calculated_level";
  RiskScoreFields[RiskScoreFields["userName"] = _types.EntityIdentifierFields.userName] = "userName";
  RiskScoreFields["userRiskScore"] = "user.risk.calculated_score_norm";
  RiskScoreFields["userRisk"] = "user.risk.calculated_level";
  RiskScoreFields[RiskScoreFields["serviceName"] = _types.EntityIdentifierFields.serviceName] = "serviceName";
  RiskScoreFields["serviceRiskScore"] = "service.risk.calculated_score_norm";
  RiskScoreFields["serviceRisk"] = "service.risk.calculated_level";
  RiskScoreFields["alertsCount"] = "alertsCount";
  RiskScoreFields["unsupported"] = "unsupported";
  return RiskScoreFields;
}({}); // Temporary value used while we don't support the universal entity
const EMPTY_SEVERITY_COUNT = exports.EMPTY_SEVERITY_COUNT = {
  [_common.EntityRiskLevelsEnum.Critical]: 0,
  [_common.EntityRiskLevelsEnum.High]: 0,
  [_common.EntityRiskLevelsEnum.Low]: 0,
  [_common.EntityRiskLevelsEnum.Moderate]: 0,
  [_common.EntityRiskLevelsEnum.Unknown]: 0
};
const EntityTypeToLevelField = exports.EntityTypeToLevelField = {
  [_types.EntityType.host]: RiskScoreFields.hostRisk,
  [_types.EntityType.user]: RiskScoreFields.userRisk,
  [_types.EntityType.service]: RiskScoreFields.serviceRisk,
  [_types.EntityType.generic]: RiskScoreFields.unsupported // We don't calculate risk for the generic entity
};
const EntityTypeToScoreField = exports.EntityTypeToScoreField = {
  [_types.EntityType.host]: RiskScoreFields.hostRiskScore,
  [_types.EntityType.user]: RiskScoreFields.userRiskScore,
  [_types.EntityType.service]: RiskScoreFields.serviceRiskScore,
  [_types.EntityType.generic]: RiskScoreFields.unsupported // We don't calculate risk for the generic entity
};