"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CROWDSTRIKE_INDEX_PATTERNS_BY_INTEGRATION = exports.CROWDSTRIKE_HOST_INDEX_PATTERN = void 0;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CROWDSTRIKE_HOST_INDEX_PATTERN = exports.CROWDSTRIKE_HOST_INDEX_PATTERN = 'logs-crowdstrike.host-*';

/**
 * List of all crowdstrike index patterns by integration
 */
const CROWDSTRIKE_INDEX_PATTERNS_BY_INTEGRATION = exports.CROWDSTRIKE_INDEX_PATTERNS_BY_INTEGRATION = (0, _std.deepFreeze)({
  crowdstrike: ['logs-crowdstrike.alert-*', 'logs-crowdstrike.falcon-*', 'logs-crowdstrike.fdr-*', CROWDSTRIKE_HOST_INDEX_PATTERN, 'logs-crowdstrike.vulnerability-*']
});