"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkDnsSchema = exports.NetworkDnsFields = void 0;
var _zod = require("@kbn/zod");
var _factory_query_type = require("../model/factory_query_type");
var _request_paginated_options = require("../model/request_paginated_options");
var _sort = require("../model/sort");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let NetworkDnsFields = exports.NetworkDnsFields = /*#__PURE__*/function (NetworkDnsFields) {
  NetworkDnsFields["dnsName"] = "dnsName";
  NetworkDnsFields["queryCount"] = "queryCount";
  NetworkDnsFields["uniqueDomains"] = "uniqueDomains";
  NetworkDnsFields["dnsBytesIn"] = "dnsBytesIn";
  NetworkDnsFields["dnsBytesOut"] = "dnsBytesOut";
  return NetworkDnsFields;
}({});
const networkDnsSchema = exports.networkDnsSchema = _request_paginated_options.requestOptionsPaginatedSchema.extend({
  isPtrIncluded: _zod.z.boolean().default(false),
  stackByField: _zod.z.string().optional(),
  sort: _sort.sort,
  timerange: _timerange.timerange,
  factoryQueryType: _zod.z.literal(_factory_query_type.NetworkQueries.dns)
});