"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersQueries = exports.ServicesQueries = exports.RelatedEntitiesQueries = exports.NetworkQueries = exports.HostsQueries = exports.FirstLastSeenQuery = exports.EntityRiskQueries = exports.CtiQueries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let HostsQueries = exports.HostsQueries = /*#__PURE__*/function (HostsQueries) {
  HostsQueries["details"] = "hostDetails";
  HostsQueries["hosts"] = "hosts";
  HostsQueries["overview"] = "overviewHost";
  HostsQueries["uncommonProcesses"] = "uncommonProcesses";
  return HostsQueries;
}({});
let UsersQueries = exports.UsersQueries = /*#__PURE__*/function (UsersQueries) {
  UsersQueries["observedDetails"] = "observedUserDetails";
  UsersQueries["managedDetails"] = "managedUserDetails";
  UsersQueries["users"] = "allUsers";
  UsersQueries["authentications"] = "authentications";
  return UsersQueries;
}({});
let ServicesQueries = exports.ServicesQueries = /*#__PURE__*/function (ServicesQueries) {
  ServicesQueries["observedDetails"] = "observedServiceDetails";
  return ServicesQueries;
}({});
let NetworkQueries = exports.NetworkQueries = /*#__PURE__*/function (NetworkQueries) {
  NetworkQueries["details"] = "networkDetails";
  NetworkQueries["dns"] = "dns";
  NetworkQueries["http"] = "http";
  NetworkQueries["overview"] = "overviewNetwork";
  NetworkQueries["tls"] = "tls";
  NetworkQueries["topCountries"] = "topCountries";
  NetworkQueries["topNFlowCount"] = "topNFlowCount";
  NetworkQueries["topNFlow"] = "topNFlow";
  NetworkQueries["users"] = "users";
  return NetworkQueries;
}({});
let EntityRiskQueries = exports.EntityRiskQueries = /*#__PURE__*/function (EntityRiskQueries) {
  EntityRiskQueries["list"] = "listEntitiesRiskScore";
  EntityRiskQueries["kpi"] = "kpiRiskScore";
  return EntityRiskQueries;
}({});
let CtiQueries = exports.CtiQueries = /*#__PURE__*/function (CtiQueries) {
  CtiQueries["eventEnrichment"] = "eventEnrichment";
  CtiQueries["dataSource"] = "dataSource";
  return CtiQueries;
}({});
const FirstLastSeenQuery = exports.FirstLastSeenQuery = 'firstlastseen';
let RelatedEntitiesQueries = exports.RelatedEntitiesQueries = /*#__PURE__*/function (RelatedEntitiesQueries) {
  RelatedEntitiesQueries["relatedHosts"] = "relatedHosts";
  RelatedEntitiesQueries["relatedUsers"] = "relatedUsers";
  return RelatedEntitiesQueries;
}({});