"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesProductFeaturesConfig = void 0;
var _product_features_keys = require("../product_features_keys");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesProductFeaturesConfig = ({
  apiTags,
  uiCapabilities
}) => ({
  [_product_features_keys.ProductFeatureCasesKey.casesConnectors]: {
    privileges: {
      all: {
        api: apiTags.connectors.all,
        ui: uiCapabilities.connectors.all,
        cases: {
          push: [_constants.APP_ID]
        }
      },
      read: {
        api: apiTags.connectors.read,
        ui: uiCapabilities.connectors.read
      }
    }
  }
});
exports.getCasesProductFeaturesConfig = getCasesProductFeaturesConfig;