"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FipsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FipsService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isInitialLicenseLoaded", void 0);
    this.logger = logger;
    this.isInitialLicenseLoaded = false;
  }
  setup({
    config,
    license
  }) {
    return {
      validateLicenseForFips: () => this.validateLicenseForFips(config, license)
    };
  }
  validateLicenseForFips(config, license) {
    license.features$.subscribe({
      next: features => {
        const errorMessage = `Your current license level is ${license.getLicenseType()} and does not support running in FIPS mode.`;
        if (license.isLicenseAvailable() && !this.isInitialLicenseLoaded) {
          if (config !== null && config !== void 0 && config.fipsMode.enabled && !license.getFeatures().allowFips) {
            this.logger.error(errorMessage);
            throw new Error(errorMessage);
          }
          this.isInitialLicenseLoaded = true;
        }
        if (this.isInitialLicenseLoaded && license.isLicenseAvailable() && config !== null && config !== void 0 && config.fipsMode.enabled && !features.allowFips) {
          this.logger.error(`${errorMessage} Kibana will not be able to restart. Please upgrade your license to platinum or higher.`);
        }
      },
      error: error => {
        this.logger.debug(`Unable to check license: ${error}`);
      }
    });
  }
}
exports.FipsService = FipsService;