"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSynonymsBreadcrumbs = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSynonymsBreadcrumbs = setName => {
  const {
    history,
    searchNavigation
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    const breadcrumbs = [{
      text: _i18n.i18n.translate('xpack.searchSynonyms.breadcrumbs.relevance.title', {
        defaultMessage: 'Relevance'
      })
    }];
    if (setName) {
      breadcrumbs.push({
        text: _i18n.i18n.translate('xpack.searchSynonyms.breadcrumbs.synonyms.title', {
          defaultMessage: 'Synonyms'
        }),
        ...(0, _public.reactRouterNavigate)(history, '/')
      });
      breadcrumbs.push({
        text: setName
      });
    } else {
      breadcrumbs.push({
        text: _i18n.i18n.translate('xpack.searchSynonyms.breadcrumbs.synonyms.title', {
          defaultMessage: 'Synonyms'
        })
      });
    }
    searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs(breadcrumbs);
    return () => {
      // Clear breadcrumbs on unmount;
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.clearBreadcrumbs();
    };
  }, [searchNavigation, history, setName]);
};
exports.useSynonymsBreadcrumbs = useSynonymsBreadcrumbs;