"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebooksPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _reactQuery = require("@tanstack/react-query");
var _console_view = require("./console_view");
var _get_error_message = require("./utils/get_error_message");
var _usage_tracker = require("./utils/usage_tracker");
var _notebook_query_param = require("./utils/notebook_query_param");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchNotebooksPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "notebooksList", null);
    (0, _defineProperty2.default)(this, "queryClient", void 0);
    (0, _defineProperty2.default)(this, "usageTracker", void 0);
  }
  setup(core) {
    this.queryClient = new _reactQuery.QueryClient({
      mutationCache: new _reactQuery.MutationCache({
        onError: error => {
          core.notifications.toasts.addError(error, {
            title: error.name,
            toastMessage: (0, _get_error_message.getErrorMessage)(error),
            toastLifeTimeMs: 1000
          });
        }
      }),
      queryCache: new _reactQuery.QueryCache({
        onError: error => {
          // 404s are often functionally okay and shouldn't show toasts by default
          if ((0, _get_error_message.getErrorCode)(error) === 404) {
            return;
          }
          if ((0, _get_error_message.isKibanaServerError)(error) && !error.skipToast) {
            core.notifications.toasts.addError(error, {
              title: error.name,
              toastMessage: (0, _get_error_message.getErrorMessage)(error),
              toastLifeTimeMs: 1000
            });
          }
        }
      })
    });
    return {};
  }
  start(core, deps) {
    var _deps$console;
    this.usageTracker = (0, _usage_tracker.createUsageTracker)(deps.usageCollection);
    if ((_deps$console = deps.console) !== null && _deps$console !== void 0 && _deps$console.registerEmbeddedConsoleAlternateView) {
      deps.console.registerEmbeddedConsoleAlternateView((0, _console_view.notebooksConsoleView)(core, this.queryClient, this.usageTracker, this.clearNotebooksState.bind(this), this.getNotebookList.bind(this)));
    }
    return {
      setNotebookList: value => {
        this.setNotebookList(value);
      },
      setSelectedNotebook: value => {
        (0, _notebook_query_param.setNotebookParameter)(value);
      }
    };
  }
  stop() {}
  clearNotebooksState() {
    this.setNotebookList(null);
    (0, _notebook_query_param.removeNotebookParameter)();
  }
  setNotebookList(value) {
    this.notebooksList = value;
  }
  getNotebookList() {
    return this.notebooksList;
  }
}
exports.SearchNotebooksPlugin = SearchNotebooksPlugin;