"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebook = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ipynb = require("@kbn/ipynb");
var _use_notebook = require("../hooks/use_notebook");
var _use_usage_tracker = require("../hooks/use_usage_tracker");
var _loading_panel = require("./loading_panel");
var _search_notebook_error = require("./search_notebook_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_notebooks/public/components/search_notebook.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchNotebook = ({
  notebookId
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    data,
    isLoading,
    error
  } = (0, _use_notebook.useNotebook)(notebookId);
  (0, _react.useEffect)(() => {
    usageTracker.count(['view-notebook', `nb-${notebookId}`]);
  }, [usageTracker, notebookId]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 12
      }
    });
  }
  if (!data || error) {
    return /*#__PURE__*/_react.default.createElement(_search_notebook_error.SearchNotebookError, {
      notebookId: notebookId,
      usageTracker: usageTracker,
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xl",
    hasShadow: false,
    style: {
      display: 'flex',
      justifyContent: 'center'
    },
    "data-test-subj": `console-embedded-notebook-view-panel-${notebookId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ipynb.NotebookRenderer, {
    notebook: data.notebook,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
};
exports.SearchNotebook = SearchNotebook;