"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabularPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _use_table_data = require("../../hooks/use_table_data");
var _use_all_inference_endpoints_state = require("../../hooks/use_all_inference_endpoints_state");
var _service_provider_filter = require("./filter/service_provider_filter");
var _task_type_filter = require("./filter/task_type_filter");
var _table_search = require("./search/table_search");
var _endpoint_info = require("./render_table_columns/render_endpoint/endpoint_info");
var _service_provider = require("./render_table_columns/render_service_provider/service_provider");
var _task_type = require("./render_table_columns/render_task_type/task_type");
var _delete_action = require("./render_table_columns/render_actions/actions/delete/delete_action");
var _use_kibana = require("../../hooks/use_kibana");
var _preconfigured_endpoint_helper = require("../../utils/preconfigured_endpoint_helper");
var _edit_inference_flyout = require("../edit_inference_endpoints/edit_inference_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/all_inference_endpoints/tabular_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TabularPage = ({
  inferenceEndpoints
}) => {
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const toasts = notifications === null || notifications === void 0 ? void 0 : notifications.toasts;
  const [showDeleteAction, setShowDeleteAction] = (0, _react.useState)(false);
  const [showInferenceFlyout, setShowInferenceFlyout] = (0, _react.useState)(false);
  const [selectedInferenceEndpoint, setSelectedInferenceEndpoint] = (0, _react.useState)(undefined);
  const [searchKey, setSearchKey] = _react.default.useState('');
  const {
    queryParams,
    setQueryParams,
    filterOptions,
    setFilterOptions
  } = (0, _use_all_inference_endpoints_state.useAllInferenceEndpointsState)();
  const copyContent = (0, _react.useCallback)(inferenceId => {
    navigator.clipboard.writeText(inferenceId).then(() => {
      toasts === null || toasts === void 0 ? void 0 : toasts.addSuccess({
        title: i18n.ENDPOINT_COPY_SUCCESS(inferenceId)
      });
    });
  }, [toasts]);
  const uniqueProvidersAndTaskTypes = (0, _react.useMemo)(() => {
    return inferenceEndpoints.reduce((acc, {
      service,
      task_type: taskType
    }) => {
      acc.providers.add(service);
      acc.taskTypes.add(taskType);
      return acc;
    }, {
      providers: new Set(),
      taskTypes: new Set()
    });
  }, [inferenceEndpoints]);
  const onCancelDeleteModal = (0, _react.useCallback)(() => {
    setSelectedInferenceEndpoint(undefined);
    setShowDeleteAction(false);
  }, []);
  const displayDeleteActionitem = (0, _react.useCallback)(selectedEndpoint => {
    setSelectedInferenceEndpoint(selectedEndpoint);
    setShowDeleteAction(true);
  }, []);
  const displayInferenceFlyout = (0, _react.useCallback)(selectedEndpoint => {
    setShowInferenceFlyout(true);
    setSelectedInferenceEndpoint(selectedEndpoint);
  }, []);
  const onCloseInferenceFlyout = (0, _react.useCallback)(() => {
    setShowInferenceFlyout(false);
    setSelectedInferenceEndpoint(undefined);
  }, []);
  const onFilterChangedCallback = (0, _react.useCallback)(newFilterOptions => {
    setFilterOptions(newFilterOptions);
  }, [setFilterOptions]);
  const {
    paginatedSortedTableData,
    pagination,
    sorting
  } = (0, _use_table_data.useTableData)(inferenceEndpoints, queryParams, filterOptions, searchKey);
  const tableColumns = (0, _react.useMemo)(() => [{
    field: 'inference_id',
    name: i18n.ENDPOINT,
    'data-test-subj': 'endpointCell',
    render: (inferenceId, endpointInfo) => {
      if (inferenceId) {
        return /*#__PURE__*/_react.default.createElement(_endpoint_info.EndpointInfo, {
          inferenceId: inferenceId,
          endpointInfo: endpointInfo,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 20
          }
        });
      }
      return null;
    },
    sortable: true,
    width: '300px'
  }, {
    field: 'service',
    name: i18n.SERVICE_PROVIDER,
    'data-test-subj': 'providerCell',
    render: (service, endpointInfo) => {
      if (service) {
        return /*#__PURE__*/_react.default.createElement(_service_provider.ServiceProvider, {
          service: service,
          endpointInfo: endpointInfo,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 20
          }
        });
      }
      return null;
    },
    sortable: false,
    width: '285px'
  }, {
    field: 'task_type',
    name: i18n.TASK_TYPE,
    'data-test-subj': 'typeCell',
    render: taskType => {
      if (taskType) {
        return /*#__PURE__*/_react.default.createElement(_task_type.TaskType, {
          type: taskType,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 20
          }
        });
      }
      return null;
    },
    sortable: false,
    width: '100px'
  }, {
    actions: [{
      name: i18n.ENDPOINT_VIEW_ACTION_LABEL,
      description: i18n.ENDPOINT_VIEW_ACTION_LABEL,
      icon: 'eye',
      type: 'icon',
      onClick: item => displayInferenceFlyout(item),
      'data-test-subj': 'inference-endpoints-action-view-endpoint-label'
    }, {
      name: i18n.ENDPOINT_COPY_ID_ACTION_LABEL,
      description: i18n.ENDPOINT_COPY_ID_ACTION_LABEL,
      icon: 'copyClipboard',
      type: 'icon',
      onClick: item => copyContent(item.inference_id),
      'data-test-subj': 'inference-endpoints-action-copy-id-label'
    }, {
      name: i18n.ENDPOINT_DELETE_ACTION_LABEL,
      description: i18n.ENDPOINT_DELETE_ACTION_LABEL,
      icon: 'trash',
      type: 'icon',
      enabled: item => !(0, _preconfigured_endpoint_helper.isEndpointPreconfigured)(item.inference_id),
      onClick: item => displayDeleteActionitem(item),
      'data-test-subj': item => (0, _preconfigured_endpoint_helper.isEndpointPreconfigured)(item.inference_id) ? 'inferenceUIDeleteAction-preconfigured' : 'inferenceUIDeleteAction-user-defined'
    }],
    width: '165px'
  }], [copyContent, displayDeleteActionitem, displayInferenceFlyout]);
  const handleTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    const newQueryParams = {
      ...queryParams,
      ...(sort && {
        sortField: sort.field,
        sortOrder: sort.direction
      }),
      ...(page && {
        page: page.index + 1,
        perPage: page.size
      })
    };
    setQueryParams(newQueryParams);
  }, [queryParams, setQueryParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '400px'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_table_search.TableSearch, {
    searchKey: searchKey,
    setSearchKey: setSearchKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_service_provider_filter.ServiceProviderFilter, {
    optionKeys: filterOptions.provider,
    uniqueProviders: uniqueProvidersAndTaskTypes.providers,
    onChange: onFilterChangedCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_task_type_filter.TaskTypeFilter, {
    optionKeys: filterOptions.type,
    onChange: onFilterChangedCallback,
    uniqueTaskTypes: uniqueProvidersAndTaskTypes.taskTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: tableColumns,
    itemId: "id",
    items: paginatedSortedTableData,
    onChange: handleTableChange,
    pagination: pagination,
    sorting: sorting,
    "data-test-subj": "inferenceEndpointTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }))), showDeleteAction && selectedInferenceEndpoint ? /*#__PURE__*/_react.default.createElement(_delete_action.DeleteAction, {
    selectedEndpoint: selectedInferenceEndpoint,
    displayModal: showDeleteAction,
    onCancel: onCancelDeleteModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }) : null, showInferenceFlyout && selectedInferenceEndpoint ? /*#__PURE__*/_react.default.createElement(_edit_inference_flyout.EditInferenceFlyout, {
    onFlyoutClose: onCloseInferenceFlyout,
    selectedInferenceEndpoint: selectedInferenceEndpoint,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }) : null);
};
exports.TabularPage = TabularPage;