"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSampleDataStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSampleDataStatus = () => {
  const {
    sampleDataIngest
  } = (0, _use_kibana.useKibana)().services;
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: [_constants.QueryKeys.FetchSampleDataStatus],
    queryFn: sampleDataIngest === null || sampleDataIngest === void 0 ? void 0 : sampleDataIngest.getStatus
  });
  return {
    isInstalled: (data === null || data === void 0 ? void 0 : data.status) === 'installed',
    indexName: data === null || data === void 0 ? void 0 : data.indexName,
    dashboardId: data === null || data === void 0 ? void 0 : data.dashboardId,
    isLoading
  };
};
exports.useSampleDataStatus = useSampleDataStatus;