"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConnector = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createConnector = async (client, input) => {
  const {
    id: connectorId
  } = await client.transport.request({
    method: 'POST',
    path: `/_connector`,
    body: {
      ...(input.indexName && {
        index_name: input.indexName
      }),
      is_native: input.isNative,
      ...(input.language && {
        language: input.language
      }),
      name: input.name || '',
      ...(input.serviceType && {
        service_type: input.serviceType
      })
    }
  });
  if (input.pipeline) {
    await client.transport.request({
      method: 'PUT',
      path: `/_connector/${connectorId}/_pipeline`,
      body: {
        pipeline: input.pipeline
      }
    });
  }
  if (input.features) {
    await client.transport.request({
      method: 'PUT',
      path: `/_connector/${connectorId}/_features`,
      body: {
        features: input.features
      }
    });
  }
  if (input.configuration) {
    await client.transport.request({
      method: 'PUT',
      path: `/_connector/${connectorId}/_configuration`,
      body: {
        configuration: input.configuration
      }
    });
  }

  // createConnector function expects to return a Connector doc, so we fetch it from the index
  const connector = await (0, _.fetchConnectorById)(client, connectorId);
  if (!connector) {
    throw new Error(_i18n.i18n.translate('searchConnectors.server.connectors.not_found_error', {
      defaultMessage: 'Could not retrieve the created connector'
    }));
  }
  return connector;
};
exports.createConnector = createConnector;