"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCounters = getCounters;
var _reportingServer = require("@kbn/reporting-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A helper utility that can be passed around and call the usage counter service
 */
function getCounters(method, path, usageCounter) {
  return {
    /**
     * constructs a counterName from the API request method and path
     * appends an optional "path suffix" for additional context about filetype, etc
     */
    usageCounter(pathSuffix) {
      const counterName = `${method} ${path}${pathSuffix ? ':' + pathSuffix : ''}`;
      usageCounter === null || usageCounter === void 0 ? void 0 : usageCounter.incrementCounter({
        counterName,
        counterType: _reportingServer.API_USAGE_COUNTER_TYPE
      });
    },
    /**
     * appends `:{statusCode}` to the counterName if there is a statusCode
     */
    errorCounter(pathSuffix, statusCode) {
      let counterName = `${method} ${path}`;
      if (pathSuffix) {
        counterName += `:${pathSuffix}`;
      }
      if (statusCode) {
        counterName += `:${statusCode}`;
      }
      usageCounter === null || usageCounter === void 0 ? void 0 : usageCounter.incrementCounter({
        counterName,
        counterType: _reportingServer.API_USAGE_ERROR_TYPE
      });
    }
  };
}