"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportScheduleIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _rrule = require("@kbn/rrule");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_schedule_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const translations = {
  [_rrule.Frequency.HOURLY]: _i18n.i18n.translate('xpack.reporting.schedules.scheduleIndicator.hourly', {
    defaultMessage: 'Hourly'
  }),
  [_rrule.Frequency.DAILY]: _i18n.i18n.translate('xpack.reporting.schedules.scheduleIndicator.daily', {
    defaultMessage: 'Daily'
  }),
  [_rrule.Frequency.WEEKLY]: _i18n.i18n.translate('xpack.reporting.schedules.scheduleIndicator.weekly', {
    defaultMessage: 'Weekly'
  }),
  [_rrule.Frequency.MONTHLY]: _i18n.i18n.translate('xpack.reporting.schedules.scheduleIndicator.monthly', {
    defaultMessage: 'Monthly'
  })
};
const ReportScheduleIndicator = ({
  schedule
}) => {
  if (!schedule || !schedule.rrule) {
    return null;
  }
  const statusText = translations[schedule.rrule.freq];
  if (!statusText) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": `reportScheduleIndicator-${schedule.rrule.freq}`,
    color: "default",
    "aria-label": statusText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "calendar",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, statusText)));
};
exports.ReportScheduleIndicator = ReportScheduleIndicator;