"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.areResourcesSetup = areResourcesSetup;
exports.createDefaultSetupState = createDefaultSetupState;
exports.mergePartialSetupStates = mergePartialSetupStates;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDefaultSetupState() {
  return {
    data: {
      available: false
    },
    resource_management: {
      enabled: false
    },
    resources: {
      created: false,
      pre_8_9_1_data: false
    },
    settings: {
      configured: false
    }
  };
}
function areResourcesSetup(state) {
  return state.resource_management.enabled && state.resources.created && state.settings.configured;
}
function mergeRecursivePartial(base, partial) {
  return (0, _lodash.merge)(base, partial);
}
function mergePartialSetupStates(base, partials) {
  return partials.reduce(mergeRecursivePartial, base);
}