"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSavedQueryPrebuilt = exports.getPrebuiltSavedQueryIds = exports.getInstalledSavedQueriesMap = void 0;
var _lodash = require("lodash");
var _spacesUtils = require("@kbn/spaces-utils");
var _common = require("../../../common");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInstalledSavedQueriesMap = async (packageService, savedObjectsClient, spaceId) => {
  const installation = await (packageService === null || packageService === void 0 ? void 0 : packageService.getInstallation(_common.OSQUERY_INTEGRATION_NAME, savedObjectsClient));
  if (installation) {
    var _installation$install, _installation$additio;
    let installedSavedQueries = [];
    if (((_installation$install = installation.installed_kibana_space_id) !== null && _installation$install !== void 0 ? _installation$install : _spacesUtils.DEFAULT_SPACE_ID) === spaceId) {
      installedSavedQueries = installation.installed_kibana;
    } else if ((_installation$additio = installation.additional_spaces_installed_kibana) !== null && _installation$additio !== void 0 && _installation$additio[spaceId]) {
      installedSavedQueries = installation.additional_spaces_installed_kibana[spaceId];
    }
    return (0, _lodash.reduce)(installedSavedQueries, (acc, item) => {
      if (item.type === _types.savedQuerySavedObjectType) {
        return {
          ...acc,
          [item.id]: item
        };
      }
      return acc;
    }, {});
  }
  return {};
};
exports.getInstalledSavedQueriesMap = getInstalledSavedQueriesMap;
const getPrebuiltSavedQueryIds = async packageService => {
  const installation = await (packageService === null || packageService === void 0 ? void 0 : packageService.getInstallation(_common.OSQUERY_INTEGRATION_NAME));
  if (installation) {
    const installationSavedQueries = (0, _lodash.filter)(installation.installed_kibana, item => item.type === _types.savedQuerySavedObjectType);
    return (0, _lodash.map)(installationSavedQueries, 'id');
  }
  return [];
};
exports.getPrebuiltSavedQueryIds = getPrebuiltSavedQueryIds;
const isSavedQueryPrebuilt = async (packageService, savedQueryId, savedObjectsClient, spaceId) => {
  const installation = await (packageService === null || packageService === void 0 ? void 0 : packageService.getInstallation(_common.OSQUERY_INTEGRATION_NAME, savedObjectsClient));
  if (installation) {
    var _installation$install2, _installation$additio2;
    let installedSavedQueries = [];
    if (((_installation$install2 = installation.installed_kibana_space_id) !== null && _installation$install2 !== void 0 ? _installation$install2 : _spacesUtils.DEFAULT_SPACE_ID) === spaceId) {
      installedSavedQueries = installation.installed_kibana;
    } else if ((_installation$additio2 = installation.additional_spaces_installed_kibana) !== null && _installation$additio2 !== void 0 && _installation$additio2[spaceId]) {
      installedSavedQueries = installation.additional_spaces_installed_kibana[spaceId];
    }
    const installationSavedQueries = (0, _lodash.find)(installedSavedQueries, item => item.type === _types.savedQuerySavedObjectType && item.id === savedQueryId);
    return !!installationSavedQueries;
  }
  return false;
};
exports.isSavedQueryPrebuilt = isSavedQueryPrebuilt;