"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _use_all_live_queries = require("./actions/use_all_live_queries");
var _lazy_osquery_action_params_form = require("./shared_components/lazy_osquery_action_params_form");
var _use_fetch_status = require("./fleet_integration/use_fetch_status");
var _lazy_osquery_result = require("./shared_components/lazy_osquery_result");
var _lazy_osquery_results = require("./shared_components/lazy_osquery_results");
var _common = require("../common");
var _fleet_integration = require("./fleet_integration");
var _shared_components = require("./shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class OsqueryPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "storage", new _public2.Storage(localStorage));
    this.initializerContext = initializerContext;
    this.kibanaVersion = this.initializerContext.env.packageInfo.version;
  }
  setup(core, plugins) {
    const storage = this.storage;
    const kibanaVersion = this.kibanaVersion;

    // Register an application into the side navigation menu
    core.application.register({
      id: 'osquery',
      title: _common.PLUGIN_NAME,
      order: 9030,
      category: _public.DEFAULT_APP_CATEGORIES.management,
      euiIconType: 'logoOsquery',
      async mount(params) {
        // Get start services as specified in kibana.json
        const [coreStart, depsStart] = await core.getStartServices();
        // Load application bundle
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));

        // Render the application
        return renderApp(coreStart, depsStart, params, storage, kibanaVersion);
      }
    });
    core.getStartServices().then(([coreStart, depsStart]) => {
      var _plugins$cases;
      (_plugins$cases = plugins.cases) === null || _plugins$cases === void 0 ? void 0 : _plugins$cases.attachmentFramework.registerExternalReference((0, _shared_components.getExternalReferenceAttachmentRegular)({
        ...coreStart,
        ...depsStart,
        storage,
        kibanaVersion
      }));
    });

    // Return methods that should be available to other plugins
    return {};
  }
  start(core, plugins) {
    if (plugins.fleet) {
      const {
        registerExtension
      } = plugins.fleet;
      registerExtension({
        package: _common.OSQUERY_INTEGRATION_NAME,
        view: 'package-policy-create',
        Component: _fleet_integration.LazyOsqueryManagedPolicyCreateImportExtension
      });
      registerExtension({
        package: _common.OSQUERY_INTEGRATION_NAME,
        view: 'package-policy-edit',
        Component: _fleet_integration.LazyOsqueryManagedPolicyEditExtension
      });
      registerExtension({
        package: _common.OSQUERY_INTEGRATION_NAME,
        view: 'package-detail-custom',
        Component: _fleet_integration.LazyOsqueryManagedCustomButtonExtension
      });
    }
    return {
      OsqueryAction: (0, _shared_components.getLazyOsqueryAction)({
        ...core,
        ...plugins
      }),
      LiveQueryField: (0, _shared_components.getLazyLiveQueryField)({
        ...core,
        ...plugins
      }),
      OsqueryResult: (0, _lazy_osquery_result.getLazyOsqueryResult)({
        ...core,
        ...plugins,
        storage: this.storage,
        kibanaVersion: this.kibanaVersion
      }),
      OsqueryResults: (0, _lazy_osquery_results.getLazyOsqueryResults)({
        ...core,
        ...plugins,
        storage: this.storage,
        kibanaVersion: this.kibanaVersion
      }),
      OsqueryResponseActionTypeForm: (0, _lazy_osquery_action_params_form.getLazyOsqueryResponseActionTypeForm)(),
      fetchAllLiveQueries: _use_all_live_queries.useAllLiveQueries,
      fetchInstallationStatus: _use_fetch_status.useFetchStatus,
      isOsqueryAvailable: _shared_components.useIsOsqueryAvailableSimple
    };
  }
  stop() {}
}
exports.OsqueryPlugin = OsqueryPlugin;