"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackQueryLastResults = void 0;
var _reactQuery = require("@tanstack/react-query");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _kibana = require("../common/lib/kibana");
var _use_logs_data_view = require("../common/hooks/use_logs_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePackQueryLastResults = ({
  actionId,
  interval,
  startDate,
  endDate,
  skip = false
}) => {
  const data = (0, _kibana.useKibana)().services.data;
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip
  });
  return (0, _reactQuery.useQuery)(['scheduledQueryLastResults', {
    actionId
  }], async () => {
    var _lastResultsResponse$, _lastResultsResponse$2, _lastResultsResponse$3, _lastResultsResponse$4;
    const lastResultsSearchSource = await data.search.searchSource.create({
      size: 1,
      sort: [{
        '@timestamp': _common.SortDirection.desc
      }],
      query: {
        // @ts-expect-error update types
        bool: {
          filter: [{
            match_phrase: {
              action_id: actionId
            }
          }]
        }
      }
    });
    lastResultsSearchSource.setField('index', logsDataView);
    const lastResultsResponse = await (0, _rxjs.lastValueFrom)(lastResultsSearchSource.fetch$());
    const timestamp = (_lastResultsResponse$ = lastResultsResponse.rawResponse) === null || _lastResultsResponse$ === void 0 ? void 0 : (_lastResultsResponse$2 = _lastResultsResponse$.hits) === null || _lastResultsResponse$2 === void 0 ? void 0 : (_lastResultsResponse$3 = _lastResultsResponse$2.hits[0]) === null || _lastResultsResponse$3 === void 0 ? void 0 : (_lastResultsResponse$4 = _lastResultsResponse$3.fields) === null || _lastResultsResponse$4 === void 0 ? void 0 : _lastResultsResponse$4['@timestamp'][0];
    if (timestamp) {
      var _lastResultsResponse$5, _lastResultsResponse$6, _lastResultsResponse$7, _lastResultsResponse$8, _aggsResponse$rawResp, _aggsResponse$rawResp2, _aggsResponse$rawResp3, _aggsResponse$rawResp4;
      const aggsSearchSource = await data.search.searchSource.create({
        size: 1,
        query: {
          // @ts-expect-error update types
          bool: {
            filter: [{
              range: {
                '@timestamp': {
                  gte: startDate ? (0, _momentTimezone.default)(startDate).format() : (0, _momentTimezone.default)(timestamp).subtract(interval, 'seconds').format(),
                  lte: (0, _momentTimezone.default)(endDate || timestamp).format()
                }
              }
            }, {
              match_phrase: {
                action_id: actionId
              }
            }]
          }
        }
      });
      aggsSearchSource.setField('index', logsDataView);
      aggsSearchSource.setField('aggs', {
        unique_agents: {
          cardinality: {
            field: 'agent.id'
          }
        }
      });
      const aggsResponse = await (0, _rxjs.lastValueFrom)(aggsSearchSource.fetch$());
      return {
        '@timestamp': (_lastResultsResponse$5 = lastResultsResponse.rawResponse) === null || _lastResultsResponse$5 === void 0 ? void 0 : (_lastResultsResponse$6 = _lastResultsResponse$5.hits) === null || _lastResultsResponse$6 === void 0 ? void 0 : (_lastResultsResponse$7 = _lastResultsResponse$6.hits[0]) === null || _lastResultsResponse$7 === void 0 ? void 0 : (_lastResultsResponse$8 = _lastResultsResponse$7.fields) === null || _lastResultsResponse$8 === void 0 ? void 0 : _lastResultsResponse$8['@timestamp'],
        // @ts-expect-error update types
        uniqueAgentsCount: aggsResponse === null || aggsResponse === void 0 ? void 0 : (_aggsResponse$rawResp = aggsResponse.rawResponse.aggregations) === null || _aggsResponse$rawResp === void 0 ? void 0 : (_aggsResponse$rawResp2 = _aggsResponse$rawResp.unique_agents) === null || _aggsResponse$rawResp2 === void 0 ? void 0 : _aggsResponse$rawResp2.value,
        docCount: aggsResponse === null || aggsResponse === void 0 ? void 0 : (_aggsResponse$rawResp3 = aggsResponse.rawResponse) === null || _aggsResponse$rawResp3 === void 0 ? void 0 : (_aggsResponse$rawResp4 = _aggsResponse$rawResp3.hits) === null || _aggsResponse$rawResp4 === void 0 ? void 0 : _aggsResponse$rawResp4.total
      };
    }
    return null;
  }, {
    keepPreviousData: true,
    enabled: !!(!skip && actionId && logsDataView),
    refetchOnReconnect: false,
    refetchOnWindowFocus: false
  });
};
exports.usePackQueryLastResults = usePackQueryLastResults;