"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformWorkflowToolToFormData = exports.transformWorkflowFormDataForUpdate = exports.transformWorkflowFormDataForCreate = exports.transformFormDataToWorkflowTool = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformWorkflowToolToFormData = tool => {
  return {
    toolId: tool.id,
    description: tool.description,
    workflow_id: tool.configuration.workflow_id,
    labels: tool.tags,
    type: _onechatCommon.ToolType.workflow
  };
};
exports.transformWorkflowToolToFormData = transformWorkflowToolToFormData;
const transformFormDataToWorkflowTool = data => {
  return {
    id: data.toolId,
    description: data.description,
    readonly: false,
    configuration: {
      workflow_id: data.workflow_id
    },
    type: _onechatCommon.ToolType.workflow,
    tags: data.labels
  };
};
exports.transformFormDataToWorkflowTool = transformFormDataToWorkflowTool;
const transformWorkflowFormDataForCreate = data => {
  return (0, _lodash.omit)(transformFormDataToWorkflowTool(data), ['readonly']);
};
exports.transformWorkflowFormDataForCreate = transformWorkflowFormDataForCreate;
const transformWorkflowFormDataForUpdate = data => {
  return (0, _lodash.omit)(transformFormDataToWorkflowTool(data), ['id', 'type', 'readonly']);
};
exports.transformWorkflowFormDataForUpdate = transformWorkflowFormDataForUpdate;