"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAnnotation = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatAnnotation = annotation => {
  // copy message to title if title is not set
  return {
    ...annotation,
    annotation: {
      ...annotation.annotation,
      title: annotation.annotation.title || annotation.message
    }
  };
};
exports.formatAnnotation = formatAnnotation;