"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatStatValue = formatStatValue;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatStatValue(stat) {
  const {
    value,
    type
  } = stat;
  switch (type) {
    case 'bytesPerSecond':
      return `${(0, _numeral.default)(value).format('0.0b')}/s`;
    case 'number':
      return (0, _numeral.default)(value).format('0a');
    case 'percent':
      return (0, _numeral.default)(value).format('0.0%');
  }
}