"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContainer = exports.alertSearchBarStateContainer = exports.Provider = exports.DEFAULT_STATE = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STATE = exports.DEFAULT_STATE = {
  rangeFrom: 'now-24h',
  rangeTo: 'now',
  kuery: '',
  filters: [],
  groupings: []
};
const transitions = {
  setRangeFrom: state => rangeFrom => ({
    ...state,
    rangeFrom
  }),
  setRangeTo: state => rangeTo => ({
    ...state,
    rangeTo
  }),
  setKuery: state => kuery => ({
    ...state,
    kuery
  }),
  setStatus: state => status => ({
    ...state,
    status
  }),
  setFilters: state => filters => ({
    ...state,
    filters
  }),
  setSavedQueryId: state => savedQueryId => ({
    ...state,
    savedQueryId
  }),
  setControlConfigs: state => controlConfigs => ({
    ...state,
    controlConfigs
  }),
  setGroupings: state => groupings => ({
    ...state,
    groupings
  })
};
const alertSearchBarStateContainer = exports.alertSearchBarStateContainer = (0, _public.createStateContainer)(DEFAULT_STATE, transitions);
const {
  Provider,
  useContainer
} = (0, _public.createStateContainerReactHelpers)();
exports.useContainer = useContainer;
exports.Provider = Provider;