"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAutoDetectCommand = getAutoDetectCommand;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAutoDetectCommand({
  scriptDownloadUrl,
  onboardingId,
  kibanaUrl,
  installApiKey,
  ingestApiKey,
  elasticAgentVersion,
  metricsEnabled
}) {
  const scriptName = 'auto_detect.sh';
  return oneLine`
    curl ${scriptDownloadUrl} -so ${scriptName} &&
    sudo bash ${scriptName}
      --id=${onboardingId}
      --kibana-url=${kibanaUrl}
      --install-key=${installApiKey}
      --ingest-key=${ingestApiKey}
      --ea-version=${elasticAgentVersion}
      ${!metricsEnabled ? '--metrics-enabled=false' : ''}
  `;
}
function oneLine(parts, ...args) {
  const str = (0, _lodash.flatten)((0, _lodash.zip)(parts, args)).join('');
  return str.replace(/\s+/g, ' ').trim();
}