"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeKbModel = ChangeKbModel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_model_options_for_inference_endpoints = require("@kbn/ai-assistant/src/utils/get_model_options_for_inference_endpoints");
var _hooks = require("@kbn/ai-assistant/src/hooks");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/settings_tab/change_kb_model.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ChangeKbModel({
  knowledgeBase,
  currentlyDeployedInferenceId
}) {
  var _knowledgeBase$status, _knowledgeBase$status2, _knowledgeBase$status3, _knowledgeBase$status4, _knowledgeBase$status5, _knowledgeBase$status6, _knowledgeBase$status7, _knowledgeBase$status9, _knowledgeBase$status12, _knowledgeBase$status13, _knowledgeBase$status24, _knowledgeBase$status25, _knowledgeBase$status26, _knowledgeBase$status27, _knowledgeBase$status28, _knowledgeBase$status29, _knowledgeBase$status30;
  const {
    overlays
  } = (0, _public.useKibana)().services;
  const [hasLoadedCurrentModel, setHasLoadedCurrentModel] = (0, _react.useState)(false);
  const [isUpdatingModel, setIsUpdatingModel] = (0, _react.useState)(false);
  const {
    inferenceEndpoints,
    isLoading: isLoadingEndpoints,
    error
  } = (0, _hooks.useInferenceEndpoints)();
  const modelOptions = (0, _get_model_options_for_inference_endpoints.getModelOptionsForInferenceEndpoints)({
    endpoints: inferenceEndpoints
  });
  const [selectedInferenceId, setSelectedInferenceId] = (0, _react.useState)(currentlyDeployedInferenceId || '');
  const doesModelNeedRedeployment = ((_knowledgeBase$status = knowledgeBase.status) === null || _knowledgeBase$status === void 0 ? void 0 : (_knowledgeBase$status2 = _knowledgeBase$status.value) === null || _knowledgeBase$status2 === void 0 ? void 0 : _knowledgeBase$status2.inferenceModelState) === _public.InferenceModelState.MODEL_PENDING_ALLOCATION || ((_knowledgeBase$status3 = knowledgeBase.status) === null || _knowledgeBase$status3 === void 0 ? void 0 : (_knowledgeBase$status4 = _knowledgeBase$status3.value) === null || _knowledgeBase$status4 === void 0 ? void 0 : _knowledgeBase$status4.inferenceModelState) === _public.InferenceModelState.MODEL_PENDING_DEPLOYMENT;
  const isSelectedModelCurrentModel = selectedInferenceId === currentlyDeployedInferenceId;
  const isKnowledgeBaseInLoadingState = knowledgeBase.isInstalling || knowledgeBase.isWarmingUpModel || ((_knowledgeBase$status5 = knowledgeBase.status.value) === null || _knowledgeBase$status5 === void 0 ? void 0 : _knowledgeBase$status5.inferenceModelState) === _public.InferenceModelState.DEPLOYING_MODEL || ((_knowledgeBase$status6 = knowledgeBase.status) === null || _knowledgeBase$status6 === void 0 ? void 0 : (_knowledgeBase$status7 = _knowledgeBase$status6.value) === null || _knowledgeBase$status7 === void 0 ? void 0 : _knowledgeBase$status7.isReIndexing);
  (0, _react.useEffect)(() => {
    var _knowledgeBase$status8;
    if (!hasLoadedCurrentModel && modelOptions !== null && modelOptions !== void 0 && modelOptions.length && (_knowledgeBase$status8 = knowledgeBase.status) !== null && _knowledgeBase$status8 !== void 0 && _knowledgeBase$status8.value) {
      setSelectedInferenceId(currentlyDeployedInferenceId || modelOptions[0].key);
      setHasLoadedCurrentModel(true);
    }
  }, [hasLoadedCurrentModel, modelOptions, (_knowledgeBase$status9 = knowledgeBase.status) === null || _knowledgeBase$status9 === void 0 ? void 0 : _knowledgeBase$status9.value, setSelectedInferenceId, currentlyDeployedInferenceId]);
  (0, _react.useEffect)(() => {
    if (isUpdatingModel && !knowledgeBase.isInstalling && !knowledgeBase.isPolling) {
      setIsUpdatingModel(false);
    }
  }, [knowledgeBase.isInstalling, knowledgeBase.isPolling, isUpdatingModel]);
  const buttonText = (0, _react.useMemo)(() => {
    var _knowledgeBase$status10, _knowledgeBase$status11;
    if (((_knowledgeBase$status10 = knowledgeBase.status) === null || _knowledgeBase$status10 === void 0 ? void 0 : (_knowledgeBase$status11 = _knowledgeBase$status10.value) === null || _knowledgeBase$status11 === void 0 ? void 0 : _knowledgeBase$status11.inferenceModelState) === _public.InferenceModelState.NOT_INSTALLED) {
      return _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.installModelLabel', {
        defaultMessage: 'Install'
      });
    }
    if (doesModelNeedRedeployment && isSelectedModelCurrentModel) {
      return _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.redeployModelLabel', {
        defaultMessage: 'Redeploy model'
      });
    }
    return _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelLabel', {
      defaultMessage: 'Update model'
    });
  }, [doesModelNeedRedeployment, isSelectedModelCurrentModel, (_knowledgeBase$status12 = knowledgeBase.status) === null || _knowledgeBase$status12 === void 0 ? void 0 : (_knowledgeBase$status13 = _knowledgeBase$status12.value) === null || _knowledgeBase$status13 === void 0 ? void 0 : _knowledgeBase$status13.inferenceModelState]);
  const confirmationMessages = (0, _react.useMemo)(() => ({
    title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelConfirmTitle', {
      defaultMessage: 'Update Knowledge Base Model'
    }),
    message: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelConfirmMessage', {
      defaultMessage: 'This will re-index all knowledge base entries if there are any.'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelCancel', {
      defaultMessage: 'Cancel'
    })
  }), []);
  const handleInstall = (0, _react.useCallback)(() => {
    if (selectedInferenceId) {
      var _knowledgeBase$status14, _knowledgeBase$status15;
      if (((_knowledgeBase$status14 = knowledgeBase.status) === null || _knowledgeBase$status14 === void 0 ? void 0 : (_knowledgeBase$status15 = _knowledgeBase$status14.value) === null || _knowledgeBase$status15 === void 0 ? void 0 : _knowledgeBase$status15.inferenceModelState) === _public.InferenceModelState.NOT_INSTALLED || doesModelNeedRedeployment && isSelectedModelCurrentModel) {
        setIsUpdatingModel(true);
        if (doesModelNeedRedeployment) {
          knowledgeBase.warmupModel(selectedInferenceId);
        } else {
          knowledgeBase.install(selectedInferenceId);
        }
      } else {
        overlays.openConfirm(confirmationMessages.message, {
          title: confirmationMessages.title,
          cancelButtonText: confirmationMessages.cancelButtonText,
          buttonColor: 'primary'
        }).then(isConfirmed => {
          if (isConfirmed) {
            setIsUpdatingModel(true);
            knowledgeBase.install(selectedInferenceId);
          }
        });
      }
    }
  }, [selectedInferenceId, knowledgeBase, doesModelNeedRedeployment, isSelectedModelCurrentModel, overlays, confirmationMessages]);
  const superSelectOptions = modelOptions.map(option => ({
    value: option.key,
    inputDisplay: option.label,
    dropdownDisplay: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 9
      }
    }, option.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      css: {
        marginTop: 4
      },
      "data-test-subj": `observabilityAiAssistantKnowledgeBaseModelDropdownOption-${option.label}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 9
      }
    }, option.description))
  }));
  const selectInferenceModelDropdown = (0, _react.useMemo)(() => {
    var _knowledgeBase$status16, _knowledgeBase$status17, _knowledgeBase$status18, _knowledgeBase$status19, _knowledgeBase$status20, _knowledgeBase$status21, _knowledgeBase$status22, _knowledgeBase$status23;
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.errorLoadingModelsTitle', {
          defaultMessage: 'Error loading models'
        }),
        color: "danger",
        iconType: "alert",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 11
        }
      }, error.message));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        width: 354
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      fullWidth: true,
      hasDividers: true,
      isLoading: isLoadingEndpoints,
      options: superSelectOptions,
      valueOfSelected: selectedInferenceId,
      onChange: value => setSelectedInferenceId(value),
      disabled: isKnowledgeBaseInLoadingState,
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseModelDropdown",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseUpdateModelButton",
      onClick: handleInstall,
      isDisabled: !selectedInferenceId || isKnowledgeBaseInLoadingState || ((_knowledgeBase$status16 = knowledgeBase.status) === null || _knowledgeBase$status16 === void 0 ? void 0 : (_knowledgeBase$status17 = _knowledgeBase$status16.value) === null || _knowledgeBase$status17 === void 0 ? void 0 : (_knowledgeBase$status18 = _knowledgeBase$status17.endpoint) === null || _knowledgeBase$status18 === void 0 ? void 0 : _knowledgeBase$status18.inference_id) === _public.LEGACY_CUSTOM_INFERENCE_ID && selectedInferenceId === _public.ELSER_ON_ML_NODE_INFERENCE_ID || ((_knowledgeBase$status19 = knowledgeBase.status) === null || _knowledgeBase$status19 === void 0 ? void 0 : (_knowledgeBase$status20 = _knowledgeBase$status19.value) === null || _knowledgeBase$status20 === void 0 ? void 0 : _knowledgeBase$status20.inferenceModelState) !== _public.InferenceModelState.NOT_INSTALLED && selectedInferenceId === ((_knowledgeBase$status21 = knowledgeBase.status) === null || _knowledgeBase$status21 === void 0 ? void 0 : (_knowledgeBase$status22 = _knowledgeBase$status21.value) === null || _knowledgeBase$status22 === void 0 ? void 0 : (_knowledgeBase$status23 = _knowledgeBase$status22.endpoint) === null || _knowledgeBase$status23 === void 0 ? void 0 : _knowledgeBase$status23.inference_id) && !doesModelNeedRedeployment,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 11
      }
    }, buttonText)));
  }, [error, buttonText, isLoadingEndpoints, superSelectOptions, selectedInferenceId, setSelectedInferenceId, isKnowledgeBaseInLoadingState, doesModelNeedRedeployment, (_knowledgeBase$status24 = knowledgeBase.status) === null || _knowledgeBase$status24 === void 0 ? void 0 : (_knowledgeBase$status25 = _knowledgeBase$status24.value) === null || _knowledgeBase$status25 === void 0 ? void 0 : _knowledgeBase$status25.inferenceModelState, (_knowledgeBase$status26 = knowledgeBase.status) === null || _knowledgeBase$status26 === void 0 ? void 0 : (_knowledgeBase$status27 = _knowledgeBase$status26.value) === null || _knowledgeBase$status27 === void 0 ? void 0 : (_knowledgeBase$status28 = _knowledgeBase$status27.endpoint) === null || _knowledgeBase$status28 === void 0 ? void 0 : _knowledgeBase$status28.inference_id, handleInstall]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      marginBlockStart: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.setEmbeddingModelTitle', {
      defaultMessage: 'Set text embeddings model for Knowledge base'
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.knowledgeBase.setEmbeddingModelDescription', {
      defaultMessage: "Choose the default model (and language) for the Assistant's responses. The Elastic documentation will be installed by default to help the Assistant answer questions."
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/docs/explore-analyze/ai-assistant#observability-ai-assistant-requirements",
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.subtitleLearnMore', {
      defaultMessage: 'Learn more'
    }))), ((_knowledgeBase$status29 = knowledgeBase.status) === null || _knowledgeBase$status29 === void 0 ? void 0 : (_knowledgeBase$status30 = _knowledgeBase$status29.value) === null || _knowledgeBase$status30 === void 0 ? void 0 : _knowledgeBase$status30.inferenceModelState) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      css: {
        marginTop: 8
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 19
      }
    }, "\u2022", ' ', _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.EmbeddingModelStateLabel', {
      defaultMessage: 'Text embeddings model status:'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseStatus",
      color: knowledgeBase.status.value.inferenceModelState === _public.InferenceModelState.READY ? isKnowledgeBaseInLoadingState ? 'warning' : 'success' : 'default',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 23
      }
    }, knowledgeBase.status.value.inferenceModelState === _public.InferenceModelState.READY ? isKnowledgeBaseInLoadingState ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateUpdatingModel', {
      defaultMessage: 'Updating model'
    }) : _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateInstalled', {
      defaultMessage: 'Installed'
    }) : knowledgeBase.status.value.inferenceModelState === _public.InferenceModelState.NOT_INSTALLED ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateNotInstalled', {
      defaultMessage: 'Not installed'
    }) : knowledgeBase.status.value.inferenceModelState === _public.InferenceModelState.MODEL_PENDING_ALLOCATION ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateModelPendingAllocation', {
      defaultMessage: 'Model pending allocation'
    }) : knowledgeBase.status.value.inferenceModelState === _public.InferenceModelState.MODEL_PENDING_DEPLOYMENT ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateModelPendingDeployment', {
      defaultMessage: 'Model pending deployment...'
    }) : knowledgeBase.status.value.inferenceModelState === _public.InferenceModelState.DEPLOYING_MODEL ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateModelPendingDeployment', {
      defaultMessage: 'Deploying model...'
    }) : knowledgeBase.status.value.inferenceModelState)), isKnowledgeBaseInLoadingState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseLoadingSpinner",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 380,
        columnNumber: 25
      }
    })))))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.semanticSearchModelLabel', {
      defaultMessage: 'Semantic search model'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 9
    }
  }, selectInferenceModelDropdown)));
}