"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexServiceFactory = indexServiceFactory;
exports.useMlIndexUtils = void 0;
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function indexServiceFactory(dataViewsService) {
  /**
   * Retrieves the data view ID from the given name.
   * If a job is passed in, a temporary data view will be created if the requested data view doesn't exist.
   * @param name - The name or index pattern of the data view.
   * @param job - Optional job object.
   * @returns The data view ID or null if it doesn't exist.
   */
  async function getDataViewIdFromName(name, job) {
    var _dataView$id;
    const dataViews = await dataViewsService.find(name);
    const dataView = dataViews.find(dv => dv.getIndexPattern() === name);
    if (!dataView) {
      if (job !== undefined) {
        var _tempDataView$id;
        const tempDataView = await dataViewsService.create({
          id: undefined,
          name,
          title: name,
          timeFieldName: job.data_description.time_field
        });
        return (_tempDataView$id = tempDataView.id) !== null && _tempDataView$id !== void 0 ? _tempDataView$id : null;
      }
      return null;
    }
    return (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : dataView.getIndexPattern();
  }
  function getDataViewById(id) {
    if (id) {
      return dataViewsService.get(id);
    } else {
      return dataViewsService.create({});
    }
  }
  async function loadDataViewListItems() {
    return (await dataViewsService.getIdsWithTitle()).sort((a, b) => a.title.localeCompare(b.title));
  }
  return {
    getDataViewIdFromName,
    getDataViewById,
    loadDataViewListItems
  };
}
const useMlIndexUtils = () => indexServiceFactory((0, _kibana.useMlKibana)().services.data.dataViews);
exports.useMlIndexUtils = useMlIndexUtils;