"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataFrameAnalyticsOverviewCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _locator = require("../../../locator");
var _data_frame_analytics_kibana = _interopRequireDefault(require("../../data_frame_analytics/pages/analytics_management/components/empty_prompt/data_frame_analytics_kibana.png"));
var _check_capabilities = require("../../capabilities/check_capabilities");
var _kibana = require("../../contexts/kibana");
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_empty_prompt_card = require("../../components/overview/ml_empty_prompt_card");
var _empty_prompt = require("../../data_frame_analytics/pages/analytics_management/components/empty_prompt/empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/data_frame_analytics_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataFrameAnalyticsOverviewCard = () => {
  const mlLocator = (0, _kibana.useMlLocator)();
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const [hasDFAs, setHasDFAs] = (0, _react.useState)(false);
  const [canCreateDataFrameAnalytics, canStartStopDataFrameAnalytics, canGetDataFrameAnalytics] = (0, _check_capabilities.usePermissionCheck)(['canCreateDataFrameAnalytics', 'canStartStopDataFrameAnalytics', 'canGetDataFrameAnalytics']);
  const disabled = !(0, _ml_nodes_check.mlNodesAvailable)() || !canCreateDataFrameAnalytics || !canStartStopDataFrameAnalytics;
  const navigateToResultsExplorer = (0, _react.useCallback)(async () => {
    if (!mlLocator) return;
    await mlLocator.navigate({
      sectionId: 'ml',
      page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION
    });
  }, [mlLocator]);
  const navigateToDFAManagementPath = (0, _react.useCallback)(async () => {
    if (!mlManagementLocator) return;
    await mlManagementLocator.navigate({
      sectionId: 'ml',
      appId: `analytics`
    });
  }, [mlManagementLocator]);
  const availableActions = (0, _react.useMemo)(() => {
    const actions = [];
    if (hasDFAs) {
      actions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        color: "primary",
        onClick: navigateToResultsExplorer,
        isDisabled: !canGetDataFrameAnalytics,
        "data-test-subj": "mlAnalyticsResultsExplorerButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.overview.dataFrameAnalytics.resultsExplorerButtonText",
        defaultMessage: "Results explorer",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 11
        }
      })));
    }
    if (!disabled) {
      actions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        onClick: navigateToDFAManagementPath,
        isDisabled: disabled,
        "data-test-subj": "mlAnalyticsManageDFAJobsButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.overview.dataFrameAnalytics.manageJobsButton",
        defaultMessage: "Manage jobs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      })));
    }
    return actions;
  }, [disabled, navigateToDFAManagementPath, hasDFAs, navigateToResultsExplorer, canGetDataFrameAnalytics]);
  const mlApi = (0, _kibana.useMlApi)();
  (0, _react.useEffect)(() => {
    const fetchAnalytics = async () => {
      const analyticsConfigs = await mlApi.dataFrameAnalytics.getDataFrameAnalytics();
      if ((analyticsConfigs === null || analyticsConfigs === void 0 ? void 0 : analyticsConfigs.count) > 0) {
        setHasDFAs(true);
      }
    };
    fetchAnalytics();
  }, [mlApi]);
  return !hasDFAs ? /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_ml_empty_prompt_card.MLEmptyPromptCard, {
    iconSrc: _data_frame_analytics_kibana.default,
    iconAlt: _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.emptyPromptTitle', {
      defaultMessage: 'Trained analysis of your data'
    }),
    title: _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.emptyPromptTitle', {
      defaultMessage: 'Trained analysis of your data'
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.analyticsList.emptyPromptText",
      defaultMessage: "Train outlier detection, regression, or classification machine learning models using data frame analytics.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }),
    actions: availableActions,
    "data-test-subj": "mlOverviewDataFrameAnalyticsCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
};
exports.DataFrameAnalyticsOverviewCard = DataFrameAnalyticsOverviewCard;