"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _validate_job = require("../../../../../components/validate_job");
var _new_job = require("../../../../../../../common/constants/new_job");
var _skip_validatoin = require("./skip_validatoin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/validation_step/validation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const idFilterList = ['job_id_valid', 'job_group_id_valid', 'detectors_function_not_empty', 'success_bucket_span'];
const ValidationStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [nextActive, setNextActive] = (0, _react.useState)(false);
  if (jobCreator.type === _new_job.JOB_TYPE.ADVANCED) {
    // for advanced jobs, ignore time range warning as the
    // user hasn't selected a time range.
    idFilterList.push(...['time_range_short', 'success_time_range']);
  }
  function getJobConfig() {
    return {
      ...jobCreator.jobConfig,
      datafeed_config: jobCreator.datafeedConfig
    };
  }
  function getDuration() {
    return {
      start: jobCreator.start,
      end: jobCreator.end
    };
  }
  (0, _react.useEffect)(() => {
    // force basic validation to run
    jobValidator.validate(() => {}, true);
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // keep a record of the advanced validation in the jobValidator
  function setIsValid(valid) {
    jobValidator.advancedValid = valid;
    setNextActive(valid);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_validate_job.ValidateJob, {
    getJobConfig: getJobConfig,
    getDuration: getDuration,
    embedded: true,
    setIsValid: setIsValid,
    idFilterList: idFilterList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    previous: () => setCurrentStep(_step_types.WIZARD_STEPS.JOB_DETAILS),
    next: () => setCurrentStep(_step_types.WIZARD_STEPS.SUMMARY),
    nextActive: nextActive,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_skip_validatoin.SkipValidationButton, {
    nextActive: nextActive,
    setCurrentStep: setCurrentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }))), isCurrentStep === false && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 35
    }
  }));
};
exports.ValidationStep = ValidationStep;