"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryDelayInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _hooks = require("../hooks");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/datafeed_step/components/query_delay/query_delay_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryDelayInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.queryDelay);
  const {
    value: queryDelay,
    setValue: setQueryDelay
  } = (0, _hooks.useStringifiedValue)(jobCreator.queryDelay);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'queryDelayInput'
  });
  (0, _react.useEffect)(() => {
    jobCreator.queryDelay = queryDelay === '' ? null : queryDelay;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [queryDelay]);
  (0, _react.useEffect)(() => {
    setQueryDelay(jobCreator.queryDelay === null ? '' : jobCreator.queryDelay);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdate]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.queryDelay);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: queryDelay,
    placeholder: _new_job.DEFAULT_QUERY_DELAY,
    onChange: e => setQueryDelay(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputQueryDelay",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
exports.QueryDelayInput = QueryDelayInput;