"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_creator = require("./job_creator");
var _new_job = require("../../../../../../common/constants/new_job");
var _general = require("./util/general");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RareJobCreator extends _job_creator.JobCreator {
  constructor(mlApi, newJobCapsService, indexPattern, savedSearch, query) {
    super(mlApi, newJobCapsService, indexPattern, savedSearch, query);
    (0, _defineProperty2.default)(this, "_rareField", null);
    (0, _defineProperty2.default)(this, "_populationField", null);
    (0, _defineProperty2.default)(this, "_splitField", null);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.RARE);
    (0, _defineProperty2.default)(this, "_rareInPopulation", false);
    (0, _defineProperty2.default)(this, "_frequentlyRare", false);
    (0, _defineProperty2.default)(this, "_rareAgg", void 0);
    (0, _defineProperty2.default)(this, "_freqRareAgg", void 0);
    this.createdBy = _new_job.CREATED_BY_LABEL.RARE;
    this._wizardInitialized$.next(true);
    this._rareAgg = {};
    this._freqRareAgg = {};
  }
  setDefaultDetectorProperties(rare, freqRare) {
    if (rare === null || freqRare === null) {
      throw Error('rare or freq_rare aggregations missing');
    }
    this._rareAgg = rare;
    this._freqRareAgg = freqRare;
  }
  setRareField(field) {
    this._rareField = field;
    if (field === null) {
      this.removePopulationField();
      this.removeSplitField();
      this._removeDetector(0);
      this._detectors.length = 0;
      this._fields.length = 0;
      return;
    }
    const agg = this._frequentlyRare ? this._freqRareAgg : this._rareAgg;
    const dtr = {
      function: agg.id
    };
    if (this._detectors.length === 0) {
      this._addDetector(dtr, agg, field);
    } else {
      this._editDetector(dtr, agg, field, 0);
    }
    this._detectors[0].by_field_name = field.id;
  }
  get rareField() {
    return this._rareField;
  }
  get rareInPopulation() {
    return this._rareInPopulation;
  }
  set rareInPopulation(bool) {
    this._rareInPopulation = bool;
    if (bool === false) {
      this.removePopulationField();
    }
  }
  get frequentlyRare() {
    return this._frequentlyRare;
  }
  set frequentlyRare(bool) {
    this._frequentlyRare = bool;
    if (this._detectors.length) {
      const agg = bool ? this._freqRareAgg : this._rareAgg;
      this._detectors[0].function = agg.id;
      this._aggs[0] = agg;
    }
  }

  // set the population field, applying it to each detector
  setPopulationField(field) {
    this._populationField = field;
    if (this._populationField === null) {
      this.removePopulationField();
    } else {
      for (let i = 0; i < this._detectors.length; i++) {
        this._detectors[i].over_field_name = this._populationField.id;
      }
    }
  }
  removePopulationField() {
    this._populationField = null;
    this._detectors.forEach(d => {
      delete d.over_field_name;
    });
  }
  get populationField() {
    return this._populationField;
  }

  // set the split field, applying it to each detector
  setSplitField(field) {
    this._splitField = field;
    if (this._splitField === null) {
      this.removeSplitField();
    } else {
      for (let i = 0; i < this._detectors.length; i++) {
        this._detectors[i].partition_field_name = this._splitField.id;
      }
    }
  }
  removeSplitField() {
    this._detectors.forEach(d => {
      delete d.partition_field_name;
    });
  }
  get splitField() {
    return this._splitField;
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    this.createdBy = _new_job.CREATED_BY_LABEL.RARE;
    this._sparseData = (0, _general.isSparseDataJob)(job, datafeed);
    const detectors = (0, _general.getRichDetectors)(this.newJobCapsService, job, datafeed, this.additionalFields, false);
    this.removeSplitField();
    this.removePopulationField();
    this.removeAllDetectors();
    if (detectors.length) {
      var _detectors$0$agg;
      this.setRareField(detectors[0].byField);
      this.frequentlyRare = ((_detectors$0$agg = detectors[0].agg) === null || _detectors$0$agg === void 0 ? void 0 : _detectors$0$agg.id) === _mlAnomalyUtils.ML_JOB_AGGREGATION.FREQ_RARE;
      if (detectors[0].overField !== null) {
        this.setPopulationField(detectors[0].overField);
        this.rareInPopulation = true;
      }
      if (detectors[0].partitionField !== null) {
        this.setSplitField(detectors[0].partitionField);
      }
    }
  }
}
exports.RareJobCreator = RareJobCreator;