"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fillMissingChartData = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns an array with the filled in missing timestamp values for scatterplot charts.
 * @param dataWithPossibleMissingValues - An array of arrays consisting of [timestamp, doc_count]
 * @param dataWithAllValues - An array of arrays consisting of [timestamp, doc_count]
 */
const fillMissingChartData = (dataWithPossibleMissingValues, dataWithAllValues) => {
  const mappedData = new Map(dataWithPossibleMissingValues);
  const filledData = dataWithAllValues.reduce((acc, source) => {
    var _mappedData$get;
    acc.push(mappedData.has(source[0]) ? [source[0], (_mappedData$get = mappedData.get(source[0])) !== null && _mappedData$get !== void 0 ? _mappedData$get : null] : [source[0], null]);
    return acc;
  }, []);
  return filledData;
};
exports.fillMissingChartData = fillMissingChartData;