"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSpacesContextWrapper = exports.useCanManageSpacesAndSavedObjects = void 0;
var _react = require("react");
var _kibana = require("../contexts/kibana");
var _get_empty_function_component = require("../components/empty_component/get_empty_function_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCanManageSpacesAndSavedObjects = () => {
  const {
    services: {
      spaces
    }
  } = (0, _kibana.useMlKibana)();
  const canManageSpacesAndSavedObjects = (0, _react.useMemo)(() => spaces !== undefined, [spaces]);
  return canManageSpacesAndSavedObjects;
};
exports.useCanManageSpacesAndSavedObjects = useCanManageSpacesAndSavedObjects;
const useSpacesContextWrapper = () => {
  const {
    services: {
      spaces
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => spaces ? spaces.ui.components.getSpacesContextProvider : _get_empty_function_component.getEmptyFunctionComponent, [spaces]);
};
exports.useSpacesContextWrapper = useSpacesContextWrapper;