"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefreshInterval = void 0;
var _react = require("react");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../../../../contexts/kibana");
var _jobs_list = require("../../../../../../../common/constants/jobs_list");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRefreshInterval = setBlockRefresh => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    timefilter
  } = services.data.query.timefilter;
  const {
    refresh
  } = (0, _common.useRefreshAnalyticsList)();
  (0, _react.useEffect)(() => {
    let analyticsRefreshInterval = null;
    const refreshIntervalSubscription = timefilter.getRefreshIntervalUpdate$().subscribe(setAutoRefresh);
    timefilter.disableTimeRangeSelector();
    timefilter.enableAutoRefreshSelector();
    initAutoRefresh();
    function initAutoRefresh() {
      var _globalState$refreshI;
      const interval = (_globalState$refreshI = globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== null && _globalState$refreshI !== void 0 ? _globalState$refreshI : timefilter.getRefreshInterval();
      const {
        pause,
        value
      } = interval;
      if (pause === true || value === 0) {
        // the auto refresher starts in an off state
        // so switch it on and set the interval to 30s
        timefilter.setRefreshInterval({
          pause: false,
          value: _jobs_list.DEFAULT_REFRESH_INTERVAL_MS
        });
      }
      setAutoRefresh();
    }
    function setAutoRefresh() {
      const {
        value,
        pause
      } = timefilter.getRefreshInterval();
      if (pause) {
        clearRefreshInterval();
      } else {
        setRefreshInterval(value);
      }
      refresh();
    }
    function setRefreshInterval(interval) {
      clearRefreshInterval();
      if (interval >= _jobs_list.MINIMUM_REFRESH_INTERVAL_MS) {
        setBlockRefresh(false);
        const intervalId = window.setInterval(() => {
          refresh();
        }, interval);
        analyticsRefreshInterval = intervalId;
      }
    }
    function clearRefreshInterval() {
      setBlockRefresh(true);
      if (analyticsRefreshInterval !== null) {
        window.clearInterval(analyticsRefreshInterval);
      }
    }

    // useEffect cleanup
    return () => {
      refreshIntervalSubscription.unsubscribe();
      clearRefreshInterval();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []); // [] as comparator makes sure this only runs once
};
exports.useRefreshInterval = useRefreshInterval;