"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobConfigErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/job_config_error_callout/job_config_error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const jobConfigErrorTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.jobConfig.errorTitle', {
  defaultMessage: 'Unable to fetch results. An error occurred loading the job configuration data.'
});
const jobCapsErrorTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.jobCaps.errorTitle', {
  defaultMessage: "Unable to fetch results. An error occurred loading the index's field data."
});
const JobConfigErrorCallout = ({
  jobCapsServiceErrorMessage,
  jobConfigErrorMessage,
  title
}) => {
  const {
    services: {
      application: {
        getUrlForApp
      }
    }
  } = (0, _kibana.useMlKibana)();
  const containsDataViewLink = typeof jobCapsServiceErrorMessage === 'string' && jobCapsServiceErrorMessage.includes('locate that index-pattern') && jobCapsServiceErrorMessage.includes('click here to re-create');
  const message = /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, jobConfigErrorMessage ? jobConfigErrorMessage : jobCapsServiceErrorMessage);
  const newDataViewUrl = (0, _react.useMemo)(() => getUrlForApp('management', {
    path: 'kibana/indexPatterns'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const calloutBody = containsDataViewLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: newDataViewUrl,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, message) : message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: jobConfigErrorMessage ? jobConfigErrorTitle : jobCapsErrorTitle,
    color: "danger",
    iconType: "cross",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, calloutBody));
};
exports.JobConfigErrorCallout = JobConfigErrorCallout;