"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableSectionResults = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _color_range_legend = require("../../../../../components/color_range_legend");
var _kibana = require("../../../../../contexts/kibana");
var _common = require("../../../../common");
var _custom_url_utils = require("../../../../../util/custom_url_utils");
var _string_utils = require("../../../../../util/string_utils");
var _ = require(".");
var _data_view_prompt = require("../data_view_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/expandable_section/expandable_section_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showingDocs = _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.documentsShownHelpText', {
  defaultMessage: 'Showing documents for which predictions exist'
});
const showingFirstDocs = _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.firstDocumentsShownHelpText', {
  defaultMessage: 'Showing first {searchSize} documents for which predictions exist',
  values: {
    searchSize: _common.SEARCH_SIZE
  }
});
const getResultsSectionHeaderItems = (columnsWithCharts, status, tableItems, rowCount, rowCountRelation, colorRange) => {
  return columnsWithCharts.length > 0 && (tableItems.length > 0 || status === _mlDataGrid.INDEX_STATUS.LOADED) ? [{
    id: 'explorationTableTotalDocs',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.explorationTableTotalDocsLabel",
      defaultMessage: "Total docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    }),
    value: `${rowCountRelation === _mlQueryUtils.ES_CLIENT_TOTAL_HITS_RELATION.GTE ? '>' : ''}${rowCount}`
  }, ...(colorRange !== undefined ? [{
    id: 'colorRangeLegend',
    value: /*#__PURE__*/_react.default.createElement(_color_range_legend.ColorRangeLegend, {
      colorRange: colorRange,
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.colorRangeLegendTitle', {
        defaultMessage: 'Feature influence score'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 19
      }
    })
  }] : [])] : _.HEADER_ITEMS_LOADING;
};
const ExpandableSectionResults = ({
  colorRange,
  indexData,
  dataView,
  jobConfig,
  needsDestDataView,
  resultsField,
  searchQuery
}) => {
  var _application$capabili2;
  const {
    services: {
      application,
      share,
      data,
      http: {
        basePath
      },
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const dataViewId = dataView === null || dataView === void 0 ? void 0 : dataView.id;
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const discoverUrlError = (0, _react.useMemo)(() => {
    var _application$capabili;
    if (!((_application$capabili = application.capabilities.discover_v2) !== null && _application$capabili !== void 0 && _application$capabili.show)) {
      const discoverNotEnabled = _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.dataGridActions.discoverNotEnabledErrorMessage', {
        defaultMessage: 'Discover is not enabled'
      });
      return discoverNotEnabled;
    }
    if (!discoverLocator) {
      const discoverLocatorMissing = _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.dataGridActions.discoverLocatorMissingErrorMessage', {
        defaultMessage: 'No locator for Discover detected'
      });
      return discoverLocatorMissing;
    }
    if (!dataViewId) {
      const autoGeneratedDiscoverLinkError = _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.dataGridActions.autoGeneratedDiscoverLinkErrorMessage', {
        defaultMessage: 'Unable to link to Discover; no data view exists for this index'
      });
      return autoGeneratedDiscoverLinkError;
    }
  }, [(_application$capabili2 = application.capabilities.discover_v2) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show, dataViewId, discoverLocator]);
  const {
    columnsWithCharts,
    status,
    tableItems
  } = indexData;

  // Results section header items and content
  const resultsSectionHeaderItems = getResultsSectionHeaderItems(columnsWithCharts, status, tableItems, indexData.rowCount, indexData.rowCountRelation, colorRange);
  const analysisType = jobConfig && jobConfig.analysis ? (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(jobConfig.analysis) : undefined;
  const generateDiscoverUrl = (0, _react.useCallback)(async rowIndex => {
    const item = tableItems[rowIndex];
    if (discoverLocator !== undefined) {
      const url = await discoverLocator.getRedirectUrl({
        dataViewId,
        timeRange: data.query.timefilter.timefilter.getTime(),
        filters: data.query.filterManager.getFilters(),
        query: {
          language: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
          // Filter for all visible column values of supported types - except the results field values
          query: indexData.visibleColumns.filter(column => item[column] !== undefined && (typeof item[column] === 'string' || typeof item[column] === 'number') && !column.includes(resultsField)).map(column => `${(0, _esQuery.escapeKuery)(column)}:${(0, _esQuery.escapeKuery)(String(item[column]))}`).join(' and ')
        }
      });
      return url;
    }
  }, [indexData === null || indexData === void 0 ? void 0 : indexData.visibleColumns, discoverLocator, dataViewId, resultsField, tableItems, data]);
  const openCustomUrl = (item, customUrl) => {
    const timeRangeInterval = customUrl.time_range !== undefined ? (0, _mlParseInterval.parseInterval)(customUrl.time_range) : null;
    let urlPath;

    // Interval time range
    if (timeRangeInterval !== null) {
      // Create a copy of the record as we are adding properties into it.
      const record = (0, _lodash.cloneDeep)(item);
      const timestamp = record[dataView.timeFieldName];
      const configuredUrlValue = customUrl.url_value;
      if (configuredUrlValue.includes('$earliest$')) {
        const earliestMoment = (0, _moment.default)(timestamp);
        earliestMoment.subtract(timeRangeInterval);
        record.earliest = earliestMoment.toISOString(); // e.g. 2016-02-08T16:00:00.000Z
      }
      if (configuredUrlValue.includes('$latest$')) {
        const latestMoment = (0, _moment.default)(timestamp);
        latestMoment.add(timeRangeInterval);
        record.latest = latestMoment.toISOString();
      }
      urlPath = (0, _string_utils.replaceStringTokens)(customUrl.url_value, record, true);
    } else {
      // Custom time range
      // Replace any tokens in the configured url_value with values from the source record and open link in a new tab/window.
      urlPath = (0, _custom_url_utils.replaceTokensInDFAUrlValue)(customUrl, item, data.query.timefilter.timefilter.getTime());
    }
    (0, _custom_url_utils.openCustomUrlWindow)(urlPath, customUrl, basePath.get());
  };
  const trailingControlColumns = [{
    id: 'actions',
    width: 60,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.dataGridActions.columnTitle",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 9
      }
    }),
    rowCellRender: function RowCellRender({
      rowIndex
    }) {
      const item = tableItems[rowIndex];
      const [isPopoverVisible, setIsPopoverVisible] = (0, _react.useState)(false);
      const closePopover = () => setIsPopoverVisible(false);
      const actions = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "discoverApp",
        key: "custom_discover_url",
        disabled: discoverUrlError !== undefined,
        onClick: async () => {
          const openInDiscoverUrl = await generateDiscoverUrl(rowIndex);
          if (openInDiscoverUrl) {
            application.navigateToUrl(openInDiscoverUrl);
          }
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 11
        }
      }, discoverUrlError ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: discoverUrlError,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.exploration.dataGridActions.viewInDiscover",
        defaultMessage: "View in Discover",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 17
        }
      })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.exploration.dataGridActions.viewInDiscover",
        defaultMessage: "View in Discover",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 15
        }
      }))];
      if (jobConfig && jobConfig._meta && Array.isArray(jobConfig._meta.custom_urls)) {
        jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig._meta.custom_urls.forEach((customUrl, index) => {
          actions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
            key: `custom_url_${index}`,
            icon: "popout",
            onClick: () => {
              closePopover();
              openCustomUrl(item, customUrl);
            },
            "data-test-subj": `mlExplorationDataGridRowActionCustomUrlButton_${index}`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 318,
              columnNumber: 15
            }
          }, customUrl.url_name));
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        isOpen: isPopoverVisible,
        panelPaddingSize: "none",
        anchorPosition: "upCenter",
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.dataGridActions.showActionsAriaLabel', {
            defaultMessage: 'Show actions'
          }),
          iconType: "gear",
          color: "text",
          onClick: () => setIsPopoverVisible(!isPopoverVisible),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 339,
            columnNumber: 15
          }
        }),
        closePopover: closePopover,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        items: actions,
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 353,
          columnNumber: 13
        }
      }));
    }
  }];
  const renderCellPopover = (0, _react.useMemo)(() => (0, _common.renderCellPopoverFactory)({
    analysisType,
    baseline: indexData.baseline,
    data: indexData.tableItems,
    pagination: indexData.pagination,
    predictionFieldName: indexData.predictionFieldName,
    resultsField: indexData.resultsField
  }), [analysisType, indexData.baseline, indexData.tableItems, indexData.pagination, indexData.predictionFieldName, indexData.resultsField]);
  const resultsSectionContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobConfig !== undefined && needsDestDataView && /*#__PURE__*/_react.default.createElement(_data_view_prompt.DataViewPrompt, {
    destIndex: jobConfig.dest.index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 9
    }
  }), jobConfig !== undefined && ((0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(jobConfig.analysis) || (0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(jobConfig.analysis)) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    css: {
      padding: `${size.s}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 11
    }
  }, tableItems.length === _common.SEARCH_SIZE ? showingFirstDocs : showingDocs), (columnsWithCharts.length > 0 || searchQuery !== _common.defaultSearchQuery) && dataView !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, columnsWithCharts.length > 0 && (tableItems.length > 0 || status === _mlDataGrid.INDEX_STATUS.LOADED) && /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, (0, _extends2.default)({}, indexData, {
    trailingControlColumns: indexData.visibleColumns.length ? trailingControlColumns : undefined,
    dataTestSubj: "mlExplorationDataGrid",
    renderCellPopover: renderCellPopover,
    toastNotifications: toasts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 17
    }
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.ExpandableSection, {
    urlStateKey: 'results',
    dataTestId: "results",
    content: resultsSectionContent,
    headerItems: resultsSectionHeaderItems,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.explorationTableTitle",
      defaultMessage: "Results",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 7
    }
  }));
};
exports.ExpandableSectionResults = ExpandableSectionResults;