"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatternMetadata = void 0;
var _retrieve_fieldcaps = require("../../lib/fields/retrieve_fieldcaps");
var _iterate_field_caps_generator = require("../../lib/fields/iterate_field_caps_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getIndexPatternMetadata = async ({
  esClient,
  indexPattern,
  from,
  to
}) => {
  const fieldCapsMap = await (0, _retrieve_fieldcaps.retrieveFieldCaps)({
    esClient: esClient.client,
    indexPattern,
    fields: ['*'],
    timerange: {
      from,
      to
    }
  });
  const indexPatternMetadata = new Map();
  for (const [index, fields] of fieldCapsMap.entries()) {
    indexPatternMetadata.set(index, {
      hasTimeSeriesFields: false
    });
    for (const timeSeriesField of (0, _iterate_field_caps_generator.getTimeSeriesFieldCapsGenerator)(fields, {
      batchSize: 500
    })) {
      if (timeSeriesField.length > 0) {
        indexPatternMetadata.set(index, {
          hasTimeSeriesFields: true
        });
        continue;
      }
    }
  }
  return Object.fromEntries(indexPatternMetadata);
};
exports.getIndexPatternMetadata = getIndexPatternMetadata;