"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeSeriesFieldCapsGenerator = void 0;
var _constants = require("../../../common/fields/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// copied from @kbn/discover-utils to avoid cyclic dependency
const FILTER_OUT_EXACT_FIELDS_FOR_CONTENT = ['_id', '_index', '_source', '_size', '_doc_count', '_field_names', '_ignored', '_routing', '_meta', '_tier'];
function* batchGenerator(gen, batchSize) {
  let batch = [];
  for (const item of gen) {
    batch.push(item);
    if (batch.length === batchSize) {
      yield batch;
      batch = [];
    }
  }
  if (batch.length > 0) {
    yield batch;
  }
}
function* timeseriesFieldCapsGenerator(fields) {
  for (const fieldName in fields) {
    if (FILTER_OUT_EXACT_FIELDS_FOR_CONTENT.includes(fieldName)) continue;
    const capabilities = fields[fieldName];
    for (const type in capabilities) {
      if (!(type in capabilities)) continue;
      const typeInfo = capabilities[type];
      if (_constants.NUMERIC_TYPES.includes(type) && typeInfo.time_series_metric) {
        yield {
          fieldName,
          type,
          typeInfo
        };
      }
    }
  }
}
const getTimeSeriesFieldCapsGenerator = (fields, {
  batchSize
} = {
  batchSize: 100
}) => batchGenerator(timeseriesFieldCapsGenerator(fields), batchSize);
exports.getTimeSeriesFieldCapsGenerator = getTimeSeriesFieldCapsGenerator;