"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegionMapEditor = RegionMapEditor;
var _react = _interopRequireDefault(require("react"));
var _kibana_services = require("../../kibana_services");
var _view_in_maps = require("../view_in_maps");
var _utils = require("./utils");
var _region_map_vis_type = require("./region_map_vis_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/legacy_visualizations/region_map/region_map_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RegionMapEditor(props) {
  const onClick = e => {
    e.preventDefault();
    const locator = (0, _kibana_services.getShareService)().url.locators.get('MAPS_APP_REGION_MAP_LOCATOR');
    if (!locator) return;
    const query = (0, _kibana_services.getData)().query;
    locator.navigate({
      ...(0, _utils.extractLayerDescriptorParams)(props.vis),
      filters: query.filterManager.getFilters(),
      query: query.queryString.getQuery(),
      timeRange: query.timefilter.timefilter.getTime()
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view_in_maps.ViewInMaps, {
    onClick: onClick,
    visualizationLabel: _region_map_vis_type.title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 10
    }
  });
}