"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticTextProperty = void 0;
var _static_style_property = require("./static_style_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StaticTextProperty extends _static_style_property.StaticStyleProperty {
  isComplete() {
    return this.getOptions().value.length > 0;
  }
  syncTextFieldWithMb(mbLayerId, mbMap) {
    if (this.getOptions().value.length) {
      mbMap.setLayoutProperty(mbLayerId, 'text-field', this.getOptions().value);
    } else {
      if (typeof mbMap.getLayoutProperty(mbLayerId, 'text-field') !== 'undefined') {
        mbMap.setLayoutProperty(mbLayerId, 'text-field', undefined);
      }
    }
  }
}
exports.StaticTextProperty = StaticTextProperty;