"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementAppLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@kbn/deeplinks-management/constants");
var _contants = require("./contants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ManagementAppLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _constants.MANAGEMENT_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const path = `/${params.sectionId}${params.appId ? '/' + params.appId : ''}`;
      return {
        app: _contants.MANAGEMENT_APP_ID,
        path,
        state: {}
      };
    });
  }
}
exports.ManagementAppLocatorDefinition = ManagementAppLocatorDefinition;