"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onVisualizationsEdit = onVisualizationsEdit;
var _presentationUtil = require("@kbn/presentation-util");
var _load_from_library = require("../content_management/load_from_library");
var _get_editor_flyout = require("./get_editor_flyout");
var _resolve_links = require("../lib/resolve_links");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function onVisualizationsEdit(savedObjectId) {
  (0, _presentationUtil.openLazyFlyout)({
    core: _kibana_services.coreServices,
    loadContent: async ({
      closeFlyout
    }) => {
      var _linksState$links;
      let linksState;
      try {
        linksState = await (0, _load_from_library.loadFromLibrary)(savedObjectId);
      } catch (error) {
        _kibana_services.coreServices.notifications.toasts.addWarning(error.message);
        return;
      }
      return (0, _get_editor_flyout.getEditorFlyout)({
        initialState: {
          savedObjectId,
          ...linksState,
          links: await (0, _resolve_links.resolveLinks)((_linksState$links = linksState.links) !== null && _linksState$links !== void 0 ? _linksState$links : [])
        },
        closeFlyout
      });
    },
    flyoutProps: {
      'data-test-subj': 'links--panelEditor--flyout'
    }
  });
}