"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLensAlertRule = isLensAlertRule;
exports.isLensBrushEvent = isLensBrushEvent;
exports.isLensEditEvent = isLensEditEvent;
exports.isLensFilterEvent = isLensFilterEvent;
exports.isLensMultiFilterEvent = isLensMultiFilterEvent;
exports.isLensTableRowContextMenuClickEvent = isLensTableRowContextMenuClickEvent;
exports.isOperation = isOperation;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A possible table a datasource can create. This object is passed to the visualization
 * which tries to build a meaningful visualization given the shape of the table. If this
 * is possible, the visualization returns a `VisualizationSuggestion` object
 */

/**
 * Indicates what was changed in this table compared to the currently active table of this layer.
 * * `initial` means the layer associated with this table does not exist in the current configuration
 * * `unchanged` means the table is the same in the currently active configuration
 * * `reduced` means the table is a reduced version of the currently active table (some columns dropped, but not all of them)
 * * `extended` means the table is an extended version of the currently active table (added one or multiple additional columns)
 * * `reorder` means the table columns have changed order, which change the data as well
 * * `layers` means the change is a change to the layer structure, not to the table
 */

/**
 * Interface for the datasource registry
 * T type: runtime Lens state
 * P type: persisted Lens state
 * Q type: Query type (useful to filter form vs text based queries)
 */

/**
 * This is an API provided to visualizations by the frame, which calls the publicAPI on the datasource
 */

/** @internal **/

// The only way a visualization has to restrict the query building

function isOperation(operationCandidate) {
  return typeof operationCandidate === 'object' && operationCandidate !== null && 'columnId' in operationCandidate;
}

// An operation represents a column in a table, not any information
// about how the column was created such as whether it is a sum or average.
// Visualizations are able to filter based on the output, not based on the
// underlying data

/**
 * Specific type used to store some meta information on top of the Operation type
 * Rather than populate the Operation type with optional types, it can leverage a super type
 */

/**
 * Object passed to `getSuggestions` of a visualization.
 * It contains a possible table the current datasource could
 * provide and the state of the visualization if it is currently active.
 *
 * If the current datasource suggests multiple tables, `getSuggestions`
 * is called multiple times with separate `SuggestionRequest` objects.
 */

/**
 * A possible configuration of a given visualization. It is based on a `TableSuggestion`.
 * Suggestion might be shown in the UI to be chosen by the user directly, but they are
 * also applied directly under some circumstances (dragging in the first field from the data
 * panel or switching to another visualization in the chart switcher).
 */

/**
 * A visualization type advertised to the user in the chart switcher
 */

// Use same technique as TriggerContext

function isLensFilterEvent(event) {
  return event.name === 'filter';
}
function isLensMultiFilterEvent(event) {
  return event.name === 'multiFilter';
}
function isLensBrushEvent(event) {
  return event.name === 'brush';
}
function isLensEditEvent(event) {
  return event.name === 'edit';
}
function isLensTableRowContextMenuClickEvent(event) {
  return event.name === 'tableRowContextMenuClick';
}
function isLensAlertRule(event) {
  return event.name === 'alertRule';
}

/**
 * Expression renderer handlers specifically for lens renderers. This is a narrowed down
 * version of the general render handlers, specifying supported event types. If this type is
 * used, dispatched events will be handled correctly.
 */

/**
 * Configuration of a top nav entry which can be shown for specific scenarios given a certain combination of active datasource and visualization id.
 * This function gets passed the currently active visualization id and state as well as the current datasource states.
 *
 * If it returns a top nav menu entry, it is rendered along with the native Lens menu entries
 */