"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueLabelsSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/value_labels_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const valueLabelsOptions = [{
  id: `value_labels_hide`,
  value: 'hide',
  label: _i18n.i18n.translate('xpack.lens.shared.valueLabelsVisibility.auto', {
    defaultMessage: 'Hide'
  }),
  'data-test-subj': 'lns_valueLabels_hide'
}, {
  id: `value_labels_inside`,
  value: 'show',
  label: _i18n.i18n.translate('xpack.lens.shared.valueLabelsVisibility.show', {
    defaultMessage: 'Show, if able'
  }),
  'data-test-subj': 'lns_valueLabels_inside'
}];
const defaultLabel = _i18n.i18n.translate('xpack.lens.shared.chartValueLabelVisibilityLabel', {
  defaultMessage: 'Value labels'
});
const ValueLabelsSettings = ({
  isVisible = true,
  valueLabels = 'hide',
  onValueLabelChange,
  label = defaultLabel
}) => {
  var _valueLabelsOptions$f;
  if (!isVisible) {
    return null;
  }
  const isSelected = ((_valueLabelsOptions$f = valueLabelsOptions.find(({
    value
  }) => value === valueLabels)) === null || _valueLabelsOptions$f === void 0 ? void 0 : _valueLabelsOptions$f.id) || 'value_labels_hide';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    helpText: _i18n.i18n.translate('xpack.lens.shared.chartValueLabelVisibilityHelpText', {
      defaultMessage: 'Values can only be shown if space is available.'
    }),
    label: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    "data-test-subj": "lens-value-labels-visibility-btn",
    buttonSize: "compressed",
    options: valueLabelsOptions,
    idSelected: isSelected,
    onChange: modeId => {
      const newMode = valueLabelsOptions.find(({
        id
      }) => id === modeId);
      if (newMode) {
        onValueLabelChange(newMode.value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
};
exports.ValueLabelsSettings = ValueLabelsSettings;