"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnMetaFn = getColumnMetaFn;
var _helper = require("../../../react_embeddable/helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColumnMetaFn(datasourceStates) {
  var _datasources$formBase, _datasources$textBase;
  const datasources = (0, _helper.getStructuredDatasourceStates)(datasourceStates);
  if ((_datasources$formBase = datasources.formBased) !== null && _datasources$formBase !== void 0 && _datasources$formBase.layers) {
    const layers = datasources.formBased.layers;
    return (layerId, columnId) => {
      var _layers$layerId, _layers$layerId$colum, _column$params, _column$params$parent;
      const column = (_layers$layerId = layers[layerId]) === null || _layers$layerId === void 0 ? void 0 : (_layers$layerId$colum = _layers$layerId.columns) === null || _layers$layerId$colum === void 0 ? void 0 : _layers$layerId$colum[columnId];
      return {
        fieldType: column && 'params' in column ? (_column$params = column.params) === null || _column$params === void 0 ? void 0 : (_column$params$parent = _column$params.parentFormat) === null || _column$params$parent === void 0 ? void 0 : _column$params$parent.id : undefined,
        dataType: column === null || column === void 0 ? void 0 : column.dataType
      };
    };
  }
  if ((_datasources$textBase = datasources.textBased) !== null && _datasources$textBase !== void 0 && _datasources$textBase.layers) {
    const layers = datasources.textBased.layers;
    return (layerId, columnId) => {
      var _layers$layerId2, _layers$layerId2$colu, _column$meta;
      const column = (_layers$layerId2 = layers[layerId]) === null || _layers$layerId2 === void 0 ? void 0 : (_layers$layerId2$colu = _layers$layerId2.columns) === null || _layers$layerId2$colu === void 0 ? void 0 : _layers$layerId2$colu.find(c => c.columnId === columnId);
      return {
        dataType: column === null || column === void 0 ? void 0 : (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.type
      };
    };
  }
  return null;
}