"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloneLayerAction = void 0;
var _i18n = require("@kbn/i18n");
var _order_bounds = require("./order_bounds");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCloneLayerAction = props => {
  const displayName = _i18n.i18n.translate('xpack.lens.cloneLayerAriaLabel', {
    defaultMessage: 'Duplicate layer'
  });
  return {
    execute: props.execute,
    displayName,
    isCompatible: Boolean(props.activeVisualization.cloneLayer && !props.isTextBasedLanguage),
    icon: 'copy',
    'data-test-subj': `lnsLayerClone--${props.layerIndex}`,
    order: _order_bounds.FIRST_ACTION_ORDER + 1
  };
};
exports.getCloneLayerAction = getCloneLayerAction;