"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteUserChartTypeFromSessionStorage = deleteUserChartTypeFromSessionStorage;
exports.readUserChartTypeFromSessionStorage = readUserChartTypeFromSessionStorage;
exports.saveUserChartTypeToSessionStorage = saveUserChartTypeToSessionStorage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_CHART_TYPE_KEY = 'userChartType';

/**
 * Set the user's preferred chart type in sessionStorage
 */
function saveUserChartTypeToSessionStorage(chartType) {
  try {
    sessionStorage.setItem(USER_CHART_TYPE_KEY, chartType);
  } catch (e) {
    // do nothing
  }
}

/**
 * Get the user's preferred chart type from sessionStorage
 */
function readUserChartTypeFromSessionStorage() {
  try {
    return sessionStorage.getItem(USER_CHART_TYPE_KEY);
  } catch (e) {
    return null;
  }
}

/**
 * Remove the user's preferred chart type from sessionStorage
 */
function deleteUserChartTypeFromSessionStorage() {
  try {
    sessionStorage.removeItem(USER_CHART_TYPE_KEY);
  } catch (e) {
    // do nothing
  }
}