"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLegendStats = convertToLegendStats;
exports.getUpdatedVisualizationState = getUpdatedVisualizationState;
var _partition = require("./partition");
var _xy = require("./xy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertToLegendStats(attributes) {
  if (!attributes.state || attributes.visualizationType !== 'lnsXY' && attributes.visualizationType !== 'lnsPie') {
    return attributes;
  }
  const newVisualizationState = getUpdatedVisualizationState(attributes.visualizationType, attributes.state);
  return {
    ...attributes,
    state: {
      ...attributes.state,
      visualization: newVisualizationState
    }
  };
}
function getUpdatedVisualizationState(visualizationType, state) {
  if (visualizationType === 'lnsXY' && state !== null && state !== void 0 && state.visualization) {
    const visState = state.visualization;
    return (0, _xy.convertXYToLegendStats)(visState);
  }
  if (visualizationType === 'lnsPie' && state !== null && state !== void 0 && state.visualization) {
    const visState = state.visualization;
    return (0, _partition.convertPartitionToLegendStats)(visState);
  }
  return state.visualization;
}