"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _no_data_page = require("../no_data_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_react/public/page_template/no_data_page/no_data_card/no_data_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// Custom cards require all the props the EuiCard does

const NoDataCard = ({
  recommended,
  title,
  button,
  layout,
  ...cardRest
}) => {
  const footer = typeof button !== 'string' ? button : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 43
    }
  }, button || title);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({
    paddingSize: "l"
    // TODO: we should require both title and description to be passed in by consumers since defaults are not adequate.
    // see comment: https://github.com/elastic/kibana/pull/111261/files#r708399140
    ,
    title: title,
    description: _i18n.i18n.translate('kibana-react.noDataPage.noDataCard.description', {
      defaultMessage: `Proceed without collecting data`
    }),
    betaBadgeProps: recommended ? {
      label: _no_data_page.NO_DATA_RECOMMENDED
    } : undefined,
    footer: footer,
    layout: layout
  }, cardRest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }));
};
exports.NoDataCard = NoDataCard;