"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatPathInfoForCounter = formatPathInfoForCounter;
exports.getCounters = getCounters;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function to help with understanding the usage of the intercept across clients
 */
function getCounters(usageCollector) {
  return {
    usageCounter(counterName) {
      usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.incrementCounter({
        counterName,
        counterType: _constants.API_USAGE_COUNTER_TYPE
      });
    },
    errorCounter(counterName) {
      usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.incrementCounter({
        counterName,
        counterType: _constants.API_USAGE_ERROR_TYPE
      });
    }
  };
}
function formatPathInfoForCounter({
  method,
  path,
  pathSuffix,
  statusCode
}) {
  const pathRequestInfo = [path];
  pathRequestInfo.push(pathSuffix !== null && pathSuffix !== void 0 ? pathSuffix : '');
  pathRequestInfo.push(statusCode ? String(statusCode) : '');
  return `${method} ${pathRequestInfo.join(':')}`;
}